#ifndef MCN_H
#define MCN_H  1

#include <stdio.h>
#include "matrix.h"

#ifndef True
#define True 1
#endif

#ifndef False
#define False 0
#endif

#ifndef ANSI_C

FILE **option();

void  mcn_input();

void mcn_output();

int get_dimension();


#else

FILE **option(int argc,
	      char *argv[],
	      int *iterative,
	      int *interactive,
	      int *workload,
	      int *jackson,
	      int *print);

void mcn_input(VEC * alpha,  /* exogeneous arrival rate */
	      VEC * sca,    /* SCV for inter-arrival time */
	      VEC * tau,    /* mean service times */
	      VEC * scs,    /* SCV for service times */
	      MAT * P,      /* routing matrix */
	      MAT *C,
	      int * n,      /* maximum degree to use */
	      FILE *input_fp,
	      int interactive,
	      int jackson
	       );


void mcn_output(MAT * Gamma, 
		VEC * mu,
	        MAT * R,
		int d,
		int n,
		FILE * output_fp,
		VEC * rho
		);

int get_dimension(int interative,
		  FILE  * input_fp, char * prompt);

#endif
#endif
