/* vecop.c 1.3 8/18/87 */
#include	<stdio.h>
#include	"matdef.h"
static	char	rcsid[] = "$Header: /usr/local/home/des/meschach/meschach/RCS/vecop.c,v 1.1 1991/08/14 00:10:43 des Exp $";

#ifdef ANSI_C
VEC	*_cp_vec(VEC *,VEC *,int), *get_vec(int), *v_resize(VEC *,int),
		*zero_vec(VEC *);
MAT     *m_resize(MAT*, int, int);
double	__ip__(double *,double *,int);
void	__mltadd__(double *,double *,double,int),
	__smlt__(double *,double,double *,int),
	__add__(double *,double *,double *,int),
	__sub__(double *,double *,double *,int);
#else
extern	VEC	*_cp_vec(), *get_vec(), *v_resize(), *zero_vec();
extern  MAT     *m_resize();
extern	double	__ip__();
extern	void	__mltadd__(), __smlt__(), __add__(), __sub__();
#endif
#define	cp_vec(in,out)	_cp_vec(in,out,0)

/* _in_prod -- inner product of two vectors from i0 downwards */
double	_in_prod(a,b,i0)
VEC	*a,*b;
u_int	i0;
{
	u_int	limit;
	/* double	*a_v, *b_v; */
	/* register double	sum; */

	if ( a==(VEC *)NULL || b==(VEC *)NULL )
		error(E_NULL,"_in_prod");
	limit = min(a->dim,b->dim);
	if ( i0 > limit )
		error(E_BOUNDS,"_in_prod");

	return __ip__(&(a->ve[i0]),&(b->ve[i0]),(int)(limit-i0));
	/*****************************************
	a_v = &(a->ve[i0]);		b_v = &(b->ve[i0]);
	for ( i=i0; i<limit; i++ )
		sum += a_v[i]*b_v[i];
		sum += (*a_v++)*(*b_v++);

	return sum;
	******************************************/
}

/* sv_mlt -- scalar-vector multiply -- may be in-situ */
VEC	*sv_mlt(scalar,vector,out)
double	scalar;
VEC	*vector,*out;
{
	/* u_int	dim, i; */
	/* double	*out_ve, *vec_ve; */

	if ( vector==(VEC *)NULL )
		error(E_NULL,"sv_mlt");
	if ( out==(VEC *)NULL || out->dim != vector->dim )
		out = v_resize(out,vector->dim);
	if ( scalar == 0.0 )
		return zero_vec(out);
	if ( scalar == 1.0 )
		return cp_vec(vector,out);

	__smlt__(vector->ve,scalar,out->ve,(int)(vector->dim));
	/**************************************************
	dim = vector->dim;
	out_ve = out->ve;	vec_ve = vector->ve;
	for ( i=0; i<dim; i++ )
		out->ve[i] = scalar*vector->ve[i];
		(*out_ve++) = scalar*(*vec_ve++);
	**************************************************/
	return (out);
}

/* v_add -- vector addition -- may be in-situ */
VEC	*v_add(vec1,vec2,out)
VEC	*vec1,*vec2,*out;
{
	u_int	dim;
	/* double	*out_ve, *vec1_ve, *vec2_ve; */

	if ( vec1==(VEC *)NULL || vec2==(VEC *)NULL )
		error(E_NULL,"v_add");
	if ( vec1->dim != vec2->dim )
		error(E_SIZES,"v_add");
	if ( out==(VEC *)NULL || out->dim != vec1->dim )
		out = v_resize(out,vec1->dim);
	dim = vec1->dim;
	__add__(vec1->ve,vec2->ve,out->ve,(int)dim);
	/************************************************************
	out_ve = out->ve;	vec1_ve = vec1->ve;	vec2_ve = vec2->ve;
	for ( i=0; i<dim; i++ )
		out->ve[i] = vec1->ve[i]+vec2->ve[i];
		(*out_ve++) = (*vec1_ve++) + (*vec2_ve++);
	************************************************************/

	return (out);
}

/* v_mltadd -- scalar/vector multiplication and addition
		-- out = v1 + scale.v2		*/
VEC	*v_mltadd(v1,v2,scale,out)
VEC	*v1,*v2,*out;
double	scale;
{
	/* register u_int	dim, i; */
	/* double	*out_ve, *v1_ve, *v2_ve; */

	if ( v1==(VEC *)NULL || v2==(VEC *)NULL )
		error(E_NULL,"v_mltadd");
	if ( v1->dim != v2->dim )
		error(E_SIZES,"v_mltadd");
	if ( scale == 0.0 )
		return cp_vec(v1,out);
	if ( scale == 1.0 )
		return v_add(v1,v2,out);

	if ( v2 != out )
	{
	    tracecatch(out = cp_vec(v1,out),"v_mltadd");

	    /* dim = v1->dim; */
	    __mltadd__(out->ve,v2->ve,scale,(int)(v1->dim));
	}
	else
	{
	    tracecatch(out = sv_mlt(scale,v2,out),"v_mltadd");
	    out = v_add(v1,out,out);
	}
	/************************************************************
	out_ve = out->ve;	v1_ve = v1->ve;		v2_ve = v2->ve;
	for ( i=0; i < dim ; i++ )
		out->ve[i] = v1->ve[i] + scale*v2->ve[i];
		(*out_ve++) = (*v1_ve++) + scale*(*v2_ve++);
	************************************************************/

	return (out);
}

/* v_sub -- vector subtraction -- may be in-situ */
VEC	*v_sub(vec1,vec2,out)
VEC	*vec1,*vec2,*out;
{
	/* u_int	i, dim; */
	/* double	*out_ve, *vec1_ve, *vec2_ve; */

	if ( vec1==(VEC *)NULL || vec2==(VEC *)NULL )
		error(E_NULL,"v_sub");
	if ( vec1->dim != vec2->dim )
		error(E_SIZES,"v_sub");
	if ( out==(VEC *)NULL || out->dim != vec1->dim )
		out = v_resize(out,vec1->dim);

	__sub__(vec1->ve,vec2->ve,out->ve,(int)(vec1->dim));
	/************************************************************
	dim = vec1->dim;
	out_ve = out->ve;	vec1_ve = vec1->ve;	vec2_ve = vec2->ve;
	for ( i=0; i<dim; i++ )
		out->ve[i] = vec1->ve[i]-vec2->ve[i];
		(*out_ve++) = (*vec1_ve++) - (*vec2_ve++);
	************************************************************/

	return (out);
}

/* v_map -- maps function f over components of x: out[i] = f(x[i])
	-- _v_map sets out[i] = f(x[i],params) */
VEC	*v_map(f,x,out)
double	(*f)();
VEC	*x, *out;
{
	double	*x_ve, *out_ve;
	int	i, dim;

	if ( ! x || ! f )
		error(E_NULL,"v_map");
	if ( ! out || out->dim != x->dim )
		out = v_resize(out,x->dim);

	dim = x->dim;	x_ve = x->ve;	out_ve = out->ve;
	for ( i = 0; i < dim; i++ )
		*out_ve++ = (*f)(*x_ve++);

	return out;
}

VEC	*_v_map(f,params,x,out)
double	(*f)();
VEC	*x, *out;
void	*params;
{
	double	*x_ve, *out_ve;
	int	i, dim;

	if ( ! x || ! f )
		error(E_NULL,"_v_map");
	if ( ! out || out->dim != x->dim )
		out = v_resize(out,x->dim);

	dim = x->dim;	x_ve = x->ve;	out_ve = out->ve;
	for ( i = 0; i < dim; i++ )
		*out_ve++ = (*f)(params,*x_ve++);

	return out;
}

/* v_lincomb -- returns sum_i a[i].v[i], a[i] real, v[i] vectors */
VEC	*v_lincomb(n,v,a,out)
int	n;	/* number of a's and v's */
double	a[];
VEC	*v[], *out;
{
	int	i;

	if ( ! a || ! v )
		error(E_NULL,"v_lincomb");
	if ( n <= 0 )
		return VNULL;

	for ( i = 1; i < n; i++ )
		if ( out == v[i] )
		    error(E_INSITU,"v_lincomb");

	out = sv_mlt(a[0],v[0],out);
	for ( i = 1; i < n; i++ )
	{
		if ( ! v[i] )
			error(E_NULL,"v_lincomb");
		if ( v[i]->dim != out->dim )
			error(E_SIZES,"v_lincomb");
		out = v_mltadd(out,v[i],a[i],out);
	}

	return out;
}


/* v_linlist -- linear combinations taken from a list of arguments */
VEC	*v_linlist(out,v1,a1,v2,a2,v3,a3,v4,a4,v5,a5,v6,a6,v7,a7,v8,a8,
				v9,a9,v10,a10)
VEC	*out;	/* contrary to convention it must now go 1st */
VEC	*v1, *v2, *v3, *v4, *v5, *v6, *v7, *v8, *v9, *v10;
double	a1, a2, a3, a4, a5, a6, a7, a8, a9, a10;
{
	if ( ! v1 )
		return VNULL;

	/* this would be mainly used with a VNULL sentinel */
	out = sv_mlt(a1,v1,out);
	if ( out == v2 )		error(E_INSITU,"v_linlist");
	if ( v2 && out->dim != v2->dim )	error(E_SIZES,"v_linlist");
	if ( v2 ) out = v_mltadd(out,v2,a2,out); else return out;

	if ( out == v3 )		error(E_INSITU,"v_linlist");
	if ( v3 && out->dim != v3->dim )	error(E_SIZES,"v_linlist");
	if ( v3 ) out = v_mltadd(out,v3,a3,out); else return out;

	if ( out == v4 )		error(E_INSITU,"v_linlist");
	if ( v4 && out->dim != v4->dim )	error(E_SIZES,"v_linlist");
	if ( v4 ) out = v_mltadd(out,v4,a4,out); else return out;

	if ( out == v5 )		error(E_INSITU,"v_linlist");
	if ( v5 && out->dim != v5->dim )	error(E_SIZES,"v_linlist");
	if ( v5 ) out = v_mltadd(out,v5,a5,out); else return out;

	if ( out == v6 )		error(E_INSITU,"v_linlist");
	if ( v6 && out->dim != v6->dim )	error(E_SIZES,"v_linlist");
	if ( v6 ) out = v_mltadd(out,v6,a6,out); else return out;

	if ( out == v7 )		error(E_INSITU,"v_linlist");
	if ( v7 && out->dim != v7->dim )	error(E_SIZES,"v_linlist");
	if ( v7 ) out = v_mltadd(out,v7,a7,out); else return out;

	if ( out == v8 )		error(E_INSITU,"v_linlist");
	if ( v8 && out->dim != v8->dim )	error(E_SIZES,"v_linlist");
	if ( v8 ) out = v_mltadd(out,v8,a8,out); else return out;

	if ( out == v9 )		error(E_INSITU,"v_linlist");
	if ( v9 && out->dim != v9->dim )	error(E_SIZES,"v_linlist");
	if ( v9 ) out = v_mltadd(out,v9,a9,out); else return out;

	if ( out == v10 )		error(E_INSITU,"v_linlist");
	if ( v10 && out->dim != v10->dim )	error(E_SIZES,"v_linlist");
	if ( v10 ) out = v_mltadd(out,v10,a10,out); else return out;

	return out;
}



#ifndef ANSI_C
MAT *v_diag(mu, out)
     VEC * mu;
     MAT *out;
#else
MAT *v_diag(VEC * mu, MAT *out)
#endif
{
  int i;
  if ( mu ==(VEC *)NULL)
    error(E_NULL,"v_diag");
  if ( out==(MAT *)NULL || out->m != mu->dim || out->n != mu->dim)
    out = m_resize(out,mu->dim,mu->dim);
  zero_mat(out);
  for (i=0; i< out->n; i++)
    out->me[i][i] = mu->ve[i];
  return out;
}

VEC* v_mlt(v1, v2, out)
     VEC *v1;
     VEC *v2;
     VEC *out;
{
  int size, i;
  if ( v1==(VEC *)NULL ||  v2==(VEC *)NULL)
    error(E_NULL,"v_mlt");
  size = min(v1->dim, v2->dim);
  if ( out==(VEC *)NULL || out->dim != size )
    out = v_resize(out,size);
  for (i=0; i< size; i++)
    out->ve[i] = v1->ve[i]*v2->ve[i];
  return out;

}

VEC* v_inv(in, out)
     VEC *in;
     VEC *out;

{
  int i;

  if ( in ==(VEC *)NULL )
    error(E_NULL,"v_inv");
  if ( out==(VEC *)NULL)
    out = v_resize(out,in->dim);
  for (i=0; i< in->dim; i++) {
    if (in->ve[i] != 0.0 )
      out->ve[i] = 1.0/in->ve[i];
    else
      error(E_SIGNAL, "v_inv");
  }
  return out;
}
