
/*
	Matrix factorisation routines to work with the other matrix files.
*/

/* solve.c 1.2 11/25/87 */
static	char	rcsid[] = "$Header: /usr/local/home/des/meschach/meschach/RCS/solve.c,v 1.1 1991/08/14 00:10:43 des Exp $";

#include	<stdio.h>
#include	<math.h>
#include	"matrix.h"

#ifdef ANSI_C
VEC	*get_vec(int), *v_resize(VEC *,int);
#else
VEC	*get_vec(), *v_resize();
#endif

/* Most matrix factorisation routines are in-situ unless otherwise specified */

/* Usolve -- back substitution with optional over-riding diagonal
		-- can be in-situ but doesn't need to be */
VEC	*Usolve(matrix,b,out,diag)
MAT	*matrix;
VEC	*b, *out;
double	diag;
{
	u_int	dim, j;
	int	i, i_lim;
	double	**mat_ent, *mat_row, *b_ent, *out_ent, *out_col, sum;

	if ( matrix==(MAT *)NULL || b==(VEC *)NULL )
		error(E_NULL,"Usolve");
	dim = min(matrix->m,matrix->n);
	if ( b->dim < dim )
		error(E_SIZES,"Usolve");
	if ( out==(VEC *)NULL || out->dim < dim )
		out = v_resize(out,matrix->n);
	mat_ent = matrix->me;	b_ent = b->ve;	out_ent = out->ve;

	for ( i=dim-1; i>=0; i-- )
		if ( b_ent[i] != 0.0 )
		    break;
		else
		    out_ent[i] = 0.0;
	i_lim = i;

	for (    ; i>=0; i-- )
	{
		sum = b_ent[i];
		mat_row = &(mat_ent[i][i+1]);
		out_col = &(out_ent[i+1]);
		sum -= __ip__(mat_row,out_col,i_lim-i);
		/******************************************************
		for ( j=i+1; j<=i_lim; j++ )
			sum -= mat_ent[i][j]*out_ent[j];
			sum -= (*mat_row++)*(*out_col++);
		******************************************************/
		if ( diag==0.0 )
		{
			if ( mat_ent[i][i]==0.0 )
				error(E_SING,"Usolve");
			else
				out_ent[i] = sum/mat_ent[i][i];
		}
		else
			out_ent[i] = sum/diag;
	}

	return (out);
}

/* S_Usolve -- back substitution with optional over-riding diagonal
		-- can be in-situ but doesn't need to be */
VEC	*S_Usolve(matrix,b,out)
S_MAT	*matrix;
VEC	*b, *out;
{
	u_int	dim, j;
	int	i, i_lim;
	double	**mat_ent, *mat_row, *b_ent, *out_ent, *out_col, sum;

	if ( matrix==(S_MAT *)NULL || b==(VEC *)NULL )
		error(E_NULL,"S_Usolve");
	dim = matrix->n;
	if ( b->dim < dim )
		error(E_SIZES,"S_Usolve");
	if ( out==(VEC *)NULL || out->dim < dim )
		out = v_resize(out,matrix->n);
	mat_ent = matrix->me;	b_ent = b->ve;	out_ent = out->ve;

	for ( i=dim-1; i>=0; i-- )
		if ( b_ent[i] != 0.0 )
		    break;
		else
		    out_ent[i] = 0.0;
	i_lim = i;

	for (    ; i>=0; i-- )
	{
		sum = b_ent[i];
		/*
		mat_row = &(mat_ent[i][i+1]);
		out_col = &(out_ent[i+1]);
		sum -= __ip__(mat_row,out_col,i_lim-i);*/
		/*******************************************************/
		for ( j=i+1; j<=i_lim; j++ )
			sum -= mat_ent[j][i]*out_ent[j];
/*			sum -= (*mat_row++)*(*out_col++); */
		/******************************************************/
		{
		  if ( mat_ent[i][i]==0.0 )
		    error(E_SING,"Usolve");
		  else
		    out_ent[i] = sum/mat_ent[i][i];
		}
	}

	return (out);
}

/* Lsolve -- forward elimination with (optional) default diagonal value */
VEC	*Lsolve(matrix,b,out,diag)
MAT	*matrix;
VEC	*b,*out;
double	diag;
{
	u_int	dim, i, i_lim, j;
	double	**mat_ent, *mat_row, *b_ent, *out_ent, *out_col, sum;

	if ( matrix==(MAT *)NULL || b==(VEC *)NULL )
		error(E_NULL,"Lsolve");
	dim = min(matrix->m,matrix->n);
	if ( b->dim < dim )
		error(E_SIZES,"Lsolve");
	if ( out==(VEC *)NULL || out->dim < dim )
		out = v_resize(out,matrix->n);
	mat_ent = matrix->me;	b_ent = b->ve;	out_ent = out->ve;

	for ( i=0; i<dim; i++ )
		if ( b_ent[i] != 0.0 )
		    break;
		else
		    out_ent[i] = 0.0;
	i_lim = i;

	for (    ; i<dim; i++ )
	{
		sum = b_ent[i];
		mat_row = &(mat_ent[i][i_lim]);
		out_col = &(out_ent[i_lim]);
		sum -= __ip__(mat_row,out_col,(int)(i-i_lim));
		/*****************************************************
		for ( j=i_lim; j<i; j++ )
			sum -= mat_ent[i][j]*out_ent[j];
			sum -= (*mat_row++)*(*out_col++);
		******************************************************/
		if ( diag==0.0 )
		{
			if ( mat_ent[i][i]==0.0 )
				error(E_SING,"Lsolve");
			else
				out_ent[i] = sum/mat_ent[i][i];
		}
		else
			out_ent[i] = sum/diag;
	}

	return (out);
}

/* S_Lsolve -- forward elimination with (optional) default diagonal value */
VEC	*S_Lsolve(matrix,b,out)
S_MAT	*matrix;
VEC	*b,*out;
{
	u_int	dim, i, i_lim, j;
	double	**mat_ent, *mat_row, *b_ent, *out_ent, *out_col, sum;

	if ( matrix==(S_MAT *)NULL || b==(VEC *)NULL )
		error(E_NULL,"S_Lsolve");
	dim = matrix->n;
	if ( b->dim < dim )
		error(E_SIZES,"Lsolve");
	if ( out==(VEC *)NULL || out->dim < dim )
		out = v_resize(out,matrix->n);
	mat_ent = matrix->me;	b_ent = b->ve;	out_ent = out->ve;

	for ( i=0; i<dim; i++ )
		if ( b_ent[i] != 0.0 )
		    break;
		else
		    out_ent[i] = 0.0;
	i_lim = i;

	for (    ; i<dim; i++ )
	{
		sum = b_ent[i];
		mat_row = &(mat_ent[i][i_lim]);
		out_col = &(out_ent[i_lim]);
		sum -= __ip__(mat_row,out_col,(int)(i-i_lim));
		/*****************************************************
		for ( j=i_lim; j<i; j++ )
			sum -= mat_ent[i][j]*out_ent[j];
			sum -= (*mat_row++)*(*out_col++);
		******************************************************/
		{
		  if ( mat_ent[i][i]==0.0 )
		    error(E_SING,"Lsolve");
		  else
		    out_ent[i] = sum/mat_ent[i][i];
		}
	}

	return (out);
}


/* UTsolve -- forward elimination with (optional) default diagonal value
		using UPPER triangular part of matrix */
VEC	*UTsolve(A,b,out,diag)
MAT	*A;
VEC	*b,*out;
double	diag;
{
	u_int	dim, i, i_lim, j;
	double	**mat_ent,*b_ent,*out_ent,sum;

	/* printf("UTsolve debug: A = \t");	out_mat(A); */
	/* printf("\tb = \t");			out_vec(b); */
	/* printf("\tout = \t");		out_vec(out); */
	/* printf("\tdiag = \t%g\n"); */

	if ( A==(MAT *)NULL || b==(VEC *)NULL )
		error(E_NULL,"UTsolve");
	dim = min(A->m,A->n);
	if ( b->dim < dim )
		error(E_SIZES,"UTsolve");
	if ( out==(VEC *)NULL || out->dim < dim )
		out = v_resize(out,A->n);
	mat_ent = A->me;	b_ent = b->ve;	out_ent = out->ve;

	for ( i=0; i<dim; i++ )
		if ( b_ent[i] != 0.0 )
		    break;
		else
		    out_ent[i] = 0.0;
	i_lim = i;

	for (    ; i<dim; i++ )
	{
		sum = b_ent[i];
		for ( j=i_lim; j<i; j++ )
			sum -= mat_ent[j][i]*out_ent[j];
		if ( diag==0.0 )
		{
			if ( mat_ent[i][i]==0.0 )
				error(E_SING,"UTsolve");
			else
				out_ent[i] = sum/mat_ent[i][i];
		}
		else
			out_ent[i] = sum/diag;
	}

	return (out);
}

/* Dsolve -- solves Dx=b where D is the diagonal of A -- may be in-situ */
VEC	*Dsolve(A,b,x)
MAT	*A;
VEC	*b,*x;
{
	u_int	dim, i;

	if ( A==(MAT *)NULL )
		error(E_NULL,"Dsolve");
	dim = min(A->m,A->n);
	if ( b->dim < dim )
		error(E_SIZES,"Dsolve");
	if ( x==(VEC *)NULL || x->dim < dim )
		x = v_resize(x,A->n);

	for ( i=0; i<b->dim; i++ )
		if ( A->me[i][i] == 0.0 )
			error(E_SING,"Dsolve");
		else
			x->ve[i] = b->ve[i]/A->me[i][i];

	return (x);
}

/* LTsolve -- back substitution with optional over-riding diagonal
		using the LOWER triangular part of matrix
		-- can be in-situ but doesn't need to be */
VEC	*LTsolve(matrix,b,out,diag)
MAT	*matrix;
VEC	*b, *out;
double	diag;
{
	u_int	dim, j;
	int	i, i_lim;
	double	**mat_ent, *b_ent, *out_ent, sum;

	if ( matrix==(MAT *)NULL || b==(VEC *)NULL )
		error(E_NULL,"Usolve");
	dim = min(matrix->m,matrix->n);
	if ( b->dim < dim )
		error(E_SIZES,"Usolve");
	if ( out==(VEC *)NULL || out->dim < dim )
		out = v_resize(out,matrix->n);
	mat_ent = matrix->me;	b_ent = b->ve;	out_ent = out->ve;

	for ( i=dim-1; i>=0; i-- )
		if ( b_ent[i] != 0.0 )
		    break;
		else
		    out_ent[i] = 0.0;
	i_lim = i;

	for (        ; i>=0; i-- )
	{
		sum = b_ent[i];
		for ( j=i+1; j<=i_lim; j++ )
			sum -= mat_ent[j][i]*out_ent[j];
		if ( diag==0.0 )
		{
			if ( mat_ent[i][i]==0.0 )
				error(E_SING,"Usolve");
			else
				out_ent[i] = sum/mat_ent[i][i];
		}
		else
			out_ent[i] = sum/diag;
	}

	return (out);
}

