/* pxop.c 1.5 12/03/87 */
#include	<stdio.h>
#include	"matdef.h"
/*	(C) Copyright David Stewart 1987	*/
static	char	rcsid[] = "$Header: /usr/local/home/des/meschach/meschach/RCS/pxop.c,v 1.2 1992/01/17 04:13:23 des Exp $";

/**********************************************************************
Note: A permutation is often interpreted as a matrix
		(i.e. a permutation matrix).
	A permutation px represents a permutation matrix P where
		P[i][j] == 1 if and only if px->pe[i] == j
**********************************************************************/

#ifdef ANSI_C
PERM	*get_perm(int), *px_resize(PERM *,int), *cp_perm(PERM *,PERM *);
VEC	*get_vec(int), *v_resize(VEC *,int);
#else
PERM	*get_perm(), *px_resize(), *cp_perm();
VEC	*get_vec(), *v_resize();
#endif

/* px_inv -- invert permutation -- in situ
	-- taken from ACM Collected Algorithms #250 */
PERM	*px_inv(px,out)
PERM	*px, *out;
{
	int	i, j, k, n, *p;

	out = cp_perm(px, out);
	n = out->size;
	p = (int *)(out->pe);
	for ( n--; n>=0; n-- )
	{
		i = p[n];
		if ( i < 0 )	p[n] = -1 - i;
		else if ( i != n )
		{
			k = n;
			while (TRUE)
			{
				j = p[i];	p[i] = -1 - k;
				if ( j == n )
				{	p[n] = i;	break;		}
				k = i;		i = j;
			}
		}
	}
	return out;
}

/* px_mlt -- permutation multiplication (composition) */
PERM	*px_mlt(px1,px2,out)
PERM	*px1,*px2,*out;
{
	u_int	i,size;

	if ( px1==(PERM *)NULL || px2==(PERM *)NULL )
		error(E_NULL,"px_mlt");
	if ( px1->size != px2->size )
		error(E_SIZES,"px_mlt");
	if ( px1 == out || px2 == out )
		error(E_INSITU,"px_mlt");
	if ( out==(PERM *)NULL || out->size < px1->size )
		out = px_resize(out,px1->size);

	size = px1->size;
	for ( i=0; i<size; i++ )
		if ( px2->pe[i] >= size )
			error(E_BOUNDS,"px_mlt");
		else
			out->pe[i] = px1->pe[px2->pe[i]];

	return out;
}

/* px_vec -- permute vector */
VEC	*px_vec(px,vector,out)
PERM	*px;
VEC	*vector,*out;
{
	u_int	i,size;

	if ( px==(PERM *)NULL || vector==(VEC *)NULL )
		error(E_NULL,"px_vec");
	if ( px->size > vector->dim )
		error(E_SIZES,"px_vec");
	if ( vector == out )
		error(E_INSITU,"px_vec");
	if ( out==(VEC *)NULL || out->dim < vector->dim )
		out = v_resize(out,vector->dim);

	size = vector->dim;
	for ( i=0; i<size; i++ )
		if ( px->pe[i] >= size )
			error(E_BOUNDS,"px_vec");
		else
			out->ve[i] = vector->ve[px->pe[i]];

	return out;
}

/* pxinv_vec -- apply the inverse of px to x, returning the result in out
		-- may NOT be in situ */
VEC	*pxinv_vec(px,x,out)
PERM	*px;
VEC	*x, *out;
{
	u_int	i, size;

	if ( ! px || ! x )
		error(E_NULL,"pxinv_vec");
	if ( px->size > x->dim )
		error(E_SIZES,"pxinv_vec");
	if ( x == out )
		error(E_INSITU,"pxinv_vec");
	if ( ! out || out->dim < x->dim )
		out = v_resize(out,x->dim);

	size = x->dim;
	for ( i=0; i<size; i++ )
		if ( px->pe[i] >= size )
			error(E_BOUNDS,"pxinv_vec");
		else
			out->ve[px->pe[i]] = x->ve[i];

	return out;
}


/* trans_px -- transpose elements of permutation
		-- Really multiplying a permutation by a transposition */
PERM	*trans_px(px,i1,i2)
PERM	*px;		/* permutation to transpose */
u_int	i1,i2;		/* elements to transpose */
{
	u_int	temp;

	if ( px==(PERM *)NULL )
		error(E_NULL,"trans_px");

	if ( i1 < px->size && i2 < px->size )
	{
		temp = px->pe[i1];
		px->pe[i1] = px->pe[i2];
		px->pe[i2] = temp;
	}

	return px;
}

/* sign_px -- compute the ``sign'' of a permutation = +/-1 where
		px is the product of an even/odd # transpositions */
int	sign_px(px)
PERM	*px;
{
	int	numtransp, myqsort();
	PERM	*px2;

	if ( px==(PERM *)NULL )
		error(E_NULL,"sign_px");
	px2 = cp_perm(px,PNULL);
	numtransp = myqsort(px2->pe,px2->size);
	px_free(px2);

	return ( numtransp % 2 ) ? -1 : 1;
}

/* myqsort -- a cheap implementation of Quicksort on integers
		-- returns number of swaps */
int myqsort(a,num)
int	*a, num;
{
	int	i, j, tmp, v;
	int	numswaps;

	numswaps = 0;
	if ( num <= 1 )
		return 0;

	i = 0;	j = num;	v = a[0];
	for ( ; ; )
	{
		while ( a[++i] < v )
			;
		while ( a[--j] > v )
			;
		if ( i >= j )	break;

		tmp = a[i];
		a[i] = a[j];
		a[j] = tmp;
		numswaps++;
	}

	tmp = a[0];
	a[0] = a[j];
	a[j] = tmp;
	if ( j != 0 )
		numswaps++;

	numswaps += myqsort(&a[0],j);
	numswaps += myqsort(&a[j+1],num-(j+1));

	return numswaps;
}

/* px_cols -- permute columns of matrix A; out = A.px'
	-- May NOT be in situ */
MAT	*px_cols(px,A,out)
PERM	*px;
MAT	*A, *out;
{
	int	i, j, m, n, px_j;
	double	**A_me, **out_me;
	extern MAT	*get_mat();

	if ( ! A || ! px )
		error(E_NULL,"px_cols");
	if ( px->size != A->n )
		error(E_SIZES,"px_cols");
	if ( A == out )
		error(E_INSITU,"px_cols");
	m = A->m;	n = A->n;
	if ( ! out || out->m != m || out->n != n )
		out = get_mat(m,n);
	A_me = A->me;	out_me = out->me;

	for ( j = 0; j < n; j++ )
	{
		px_j = px->pe[j];
		if ( px_j >= n )
		    error(E_BOUNDS,"px_cols");
		for ( i = 0; i < m; i++ )
		    out_me[i][px_j] = A_me[i][j];
	}

	return out;
}

/* px_rows -- permute columns of matrix A; out = px.A
	-- May NOT be in situ */
MAT	*px_rows(px,A,out)
PERM	*px;
MAT	*A, *out;
{
	int	i, j, m, n, px_i;
	double	**A_me, **out_me;
	extern MAT	*get_mat();

	if ( ! A || ! px )
		error(E_NULL,"px_rows");
	if ( px->size != A->m )
		error(E_SIZES,"px_rows");
	if ( A == out )
		error(E_INSITU,"px_rows");
	m = A->m;	n = A->n;
	if ( ! out || out->m != m || out->n != n )
		out = get_mat(m,n);
	A_me = A->me;	out_me = out->me;

	for ( i = 0; i < m; i++ )
	{
		px_i = px->pe[i];
		if ( px_i >= m )
		    error(E_BOUNDS,"px_rows");
		for ( j = 0; j < n; j++ )
		    out_me[i][j] = A_me[px_i][j];
	}

	return out;
}

