/* memory.c 1.3 11/25/87 */
#include	<stdio.h>
#include	"matdef.h" 



/* get_mat -- gets an mxn matrix (in MAT form) by dynamic memory allocation */
MAT	*get_mat(m,n)
u_int	m,n;
{
	MAT	*matrix;
	u_int	i;

	if ((matrix=NEW(MAT)) == (MAT *)NULL )
		error(E_MEM,"get_mat");
	matrix->m = m;		matrix->n = matrix->max_n = n;
	matrix->max_m = m;	matrix->max_size = m*n;
#ifndef SEGMENTED
	if ((matrix->base = NEW_A(m*n,double)) == (double *)NULL )
	{
		free(matrix);
		error(E_MEM,"get_mat");
	}
#else
	matrix->base = (double *)NULL;
#endif
	if ((matrix->me = (double **)calloc(m,sizeof(double *))) == 
						(double **)NULL )
	{	free(matrix);	free(matrix->base);
		error(E_MEM,"get_mat");
	}
#ifndef SEGMENTED
	/* set up pointers */
	for ( i=0; i<m; i++ )
		matrix->me[i] = &(matrix->base[i*n]);
#else
	for ( i = 0; i < m; i++ )
	    if ( (matrix->me[i]=NEW_A(n,double)) == (double *)NULL )
		error(E_MEM,"get_mat");
#endif

	return (matrix);
}



/* get_s_mat -- gets an mxn matrix (in MAT form) by dynamic memory allocation */
S_MAT	*get_s_mat(n)
u_int	n;
{
	S_MAT	*matrix;
	u_int	i;
	u_int   size = n*(n+1)/2;

	if ((matrix=NEW(S_MAT)) == (S_MAT *)NULL )
		error(E_MEM,"get_s_mat");
	matrix->n = n;
	matrix->max_size = n;
#ifndef SEGMENTED
	if ((matrix->base = NEW_A(size,double)) == (double *)NULL )
	{
		free(matrix);
		error(E_MEM,"get_s_mat");
	}
#else
	matrix->base = (double *)NULL;
#endif
	if ((matrix->me = (double **)calloc(n,sizeof(double *))) == 
						(double **)NULL )
	{	free(matrix);	free(matrix->base);
		error(E_MEM,"get_s_mat");
	}
#ifndef SEGMENTED
	/* set up pointers */
	for ( i=0; i<n; i++ )
		matrix->me[i] = &(matrix->base[i*(i+1)/2]);
#else
	for ( i = 0; i < n; i++ )
	    if ( (matrix->me[i]=NEW_A((i+1),double)) == (double *)NULL )
		error(E_MEM,"get_s_mat");
#endif

	return (matrix);
}


/* get_perm -- gets a PERM of given 'size' by dynamic memory allocation
		-- Note: initialized to the identity permutation */
PERM	*get_perm(size)
u_int	size;
{
	PERM	*permute;
	u_int	i;

	if ((permute=NEW(PERM)) == (PERM *)NULL )
		error(E_MEM,"get_perm");
	permute->size = permute->max_size = size;
	if ((permute->pe = NEW_A(size,u_int)) == (u_int *)NULL )
		error(E_MEM,"get_perm");

	for ( i=0; i<size; i++ )
		permute->pe[i] = i;

	return (permute);
}

/* get_vec -- gets a VEC of dimension 'dim'
		-- Note: initialized to zero */
VEC	*get_vec(size)
u_int	size;
{
	VEC	*vector;

	if ((vector=NEW(VEC)) == (VEC *)NULL )
		error(E_MEM,"get_vec");
	vector->dim = vector->max_dim = size;
	if ((vector->ve=NEW_A(size,double)) == (double *)NULL )
	{
		free(vector);
		error(E_MEM,"get_vec");
	}
	return (vector);
}

/* m_free -- returns MAT & asoociated memory back to memory heap */
int	m_free(mat)
MAT	*mat;
{
	int	i;

	if ( mat==(MAT *)NULL || (int)(mat->m) < 0 ||
	    	(int)(mat->n) < 0 )
		/* don't trust it */
		return (-1);

#ifndef SEGMENTED
	if ( mat->base != (double *)NULL )
		free((char *)(mat->base));
#else
	for ( i = 0; i < mat->m; i++ )
	    if ( mat->me[i] != (double *)NULL )
		free((char *)(mat->me[i]));
#endif
	if ( mat->me != (double **)NULL )
		free((char *)(mat->me));
	free((char *)mat);

	return (0);
}

/* px_free -- returns PERM & asoociated memory back to memory heap */
int	px_free(px)
PERM	*px;
{
	if ( px==(PERM *)NULL || px->size > MAXDIM )
		/* don't trust it */
		return (-1);

	if ( px->pe == (u_int *)NULL )
		free((char *)px);
	else
	{
		free((char *)px->pe);
		free((char *)px);
	}

	return (0);
}

/* v_free -- returns VEC & asoociated memory back to memory heap */
int	v_free(vec)
VEC	*vec;
{
	if ( vec==(VEC *)NULL || vec->dim > MAXDIM )
		/* don't trust it */
		return (-1);

	if ( vec->ve == (double *)NULL )
		free((char *)vec);
	else
	{
		free((char *)vec->ve);
		free((char *)vec);
	}

	return (0);
}


/* m_resize -- returns the matrix A of size new_m x new_n; A is zeroed
	-- if A == NULL on entry then the effect is equivalent to get_mat() */
MAT	*m_resize(A,new_m,new_n)
MAT	*A;
u_int	new_m, new_n;
{
	u_int	i, new_max_m, new_max_n, new_size, old_m, old_n;
	extern	MAT *zero_mat();

	if ( ! A )
		return get_mat(new_m,new_n);

	old_m = A->m;	old_n = A->n;
	if ( new_m > A->max_m )
	{	/* re-allocate A->me */
		A->me = RENEW(A->me,new_m,double *);
		if ( ! A->me )
		    error(E_MEM,"m_resize");
	}
	new_max_m = max(new_m,A->max_m);
	new_max_n = max(new_n,A->max_n);

#ifndef SEGMENTED
	new_size = new_m*new_n;
	if ( new_size > A->max_size )
	{	/* re-allocate A->base */
		A->base = RENEW(A->base,new_size,double);
		if ( ! A->base )
			error(E_MEM,"m_resize");
		A->max_size = new_size;
	}

	/* now set up A->me[i] */
	for ( i = 0; i < new_m; i++ )
		A->me[i] = &(A->base[i*new_n]);

	/* now shift data in matrix */
	if ( old_n > new_n )
	{
		for ( i = 1; i < min(old_m,new_m); i++ )
		    mem_copy((char *)&(A->base[i*old_n]),
				(char *)&(A->base[i*new_n]),
					sizeof(double)*new_n);
	}
	else if ( old_n < new_n )
	{
		for ( i = min(old_m,new_m)-1; i > 0; i-- )
		{   /* copy & then zero extra space */
		    mem_copy((char *)&(A->base[i*old_n]),
				(char *)&(A->base[i*new_n]),
					sizeof(double)*old_n);
		    __zero__(&(A->base[i*new_n+old_n]),(new_n-old_n));
		}
		__zero__(&(A->base[old_n]),(new_n-old_n));
		A->max_n = new_n;
	}
	/* zero out the new rows.. */
	for ( i = old_m; i < new_m; i++ )
		__zero__(&(A->base[i*new_n]),new_n);
#else
	if ( A->max_n < new_n )
	{
	    double	*tmp;

	    for ( i = 0; i < new_max_m; i++ )
	    {
		if ( (tmp = RENEW(A->me[i],new_max_n,double)) == NULL )
		    error(E_MEM,"m_resize");
	        else
		    A->me[i] = tmp;
	    }
	}

	if ( A->max_m < new_m )
	{
	    for ( i = A->max_m; i < new_m; i++ )
		if ( (A->me[i] = NEW_A(new_max_n,double)) == NULL )
		    error(E_MEM,"m_resize");
	}

	if ( old_n < new_n )
	{
	    for ( i = 0; i < old_m; i++ )
		__zero__(&(A->me[i][old_n]),new_n-old_n);
	}

	/* zero out the new rows.. */
	for ( i = old_m; i < new_m; i++ )
		__zero__(A->me[i],new_n);
#endif

	A->max_m = new_max_m;
	A->max_n = new_max_n;
	A->max_size = A->max_m*A->max_n;
	A->m = new_m;	A->n = new_n;

	return A;
}

/* px_resize -- returns the permutation px with size new_size
	-- px is set to the identity permutation */
PERM	*px_resize(px,new_size)
PERM	*px;
u_int	new_size;
{
	extern PERM *px_id();
	int	i;

	if ( ! px )
		return get_perm(new_size);

	if ( new_size > px->max_size )
	{
		px->pe = RENEW(px->pe,new_size,u_int);
		if ( ! px->pe )
			error(E_MEM,"px_resize");
		px->max_size = new_size;
	}
	if ( px->size <= new_size )
		/* extend permutation */
		for ( i = px->size; i < new_size; i++ )
		    px->pe[i] = i;
	else
		for ( i = 0; i < new_size; i++ )
		    px->pe[i] = i;

	px->size = new_size;

	return px;
}

/* v_resize -- returns the vector x with dim new_dim
	-- x is set to the zero vector */
VEC	*v_resize(x,new_dim)
VEC	*x;
u_int	new_dim;
{
	extern VEC *zero_vec();

	if ( ! x )
		return get_vec(new_dim);
	if ( x->max_dim == 0 )	/* assume that it's from sub_vec */
		return get_vec(new_dim);

	if ( new_dim > x->max_dim )
	{
		x->ve = RENEW(x->ve,new_dim,double);
		if ( ! x->ve )
			error(E_MEM,"v_resize");
		x->max_dim = new_dim;
	}

	if ( new_dim > x->dim )
	    __zero__(&(x->ve[x->dim]),new_dim - x->dim);
	x->dim = new_dim;

	return x;
}

