/*
		Type definitions for general purpose maths package
	(C) Copyright David Stewart 3rd Dec 1987
*/

#ifndef	MATRIXH

#define	MATRIXH	1


#include	<setjmp.h>
#include	"machine.h"

/* vector definition */
typedef	struct	{
		u_int	dim, max_dim;
		double	*ve;
		} VEC;
/* matrix definition */
typedef	struct	{
		u_int	m, n;
		u_int	max_m, max_n, max_size;
		double	**me,*base;	/* base is base of alloc'd mem */
		} MAT;

/* symmetrix matrix definition */
typedef	struct	{
		u_int   n;
		u_int	max_size;
		double	**me,*base;	/* base is base of alloc'd mem */
		} S_MAT;


/* permutation definition */
typedef	struct	{
		u_int	size, max_size, *pe;
		} PERM;
/* integer vector definition */
typedef struct	{
		u_int	dim, max_dim;
		int	*ive;
	        } IVEC;

#ifndef MALLOCDECL
#ifndef ANSI_C
extern	char	*malloc(), *calloc(), *realloc();
#else
extern	void	*malloc(size_t),
		*calloc(size_t,size_t),
		*realloc(void *,size_t);
#endif
#endif

#ifndef ANSI_C
#define	NEW(type)	((type *)calloc(1,sizeof(type)))
#define	NEW_A(num,type)	((type *)calloc((unsigned)(num),sizeof(type)))
#define	RENEW(var,num,type) \
    ((var)=(type *)((var) ? \
		    realloc((char *)(var),(unsigned)(num)*sizeof(type)) : \
		    calloc((unsigned)(num),sizeof(type))))
#else
#define	NEW(type)	((type *)calloc((size_t)1,(size_t)sizeof(type)))
#define	NEW_A(num,type)	((type *)calloc((size_t)(num),(size_t)sizeof(type)))
#define	RENEW(var,num,type) \
    ((var)=(type *)((var) ? \
		    realloc((char *)(var),(size_t)((num)*sizeof(type))) : \
		    calloc((size_t)(num),(size_t)sizeof(type))))
#endif

#define	max(a,b)	((a) > (b) ? (a) : (b))
#define	min(a,b)	((a) > (b) ? (b) : (a))
#define	TRUE	1
#define	FALSE	0

/* Error recovery */
extern	jmp_buf	restart;
#ifndef ANSI_C
extern	ev_err();
extern	int	set_err_flag(), count_errs();
#else
extern	ev_err(char *,int,int,char *);
extern	int	set_err_flag(int flag), count_errs(int true_false);
#endif
#define	error(err_num,fn_name)	ev_err(__FILE__,err_num,__LINE__,fn_name)
#define	EF_EXIT		0
#define	EF_ABORT	1
#define	EF_JUMP		2
#define	EF_SILENT	3
#define	ERREXIT()	set_err_flag(EF_EXIT)
#define	ERRABORT()	set_err_flag(EF_ABORT)
#define	SILENTERR()	if ( ! setjmp(restart) ) set_err_flag(EF_SILENT)
#define	ON_ERROR()	if ( ! setjmp(restart) ) set_err_flag(EF_JUMP)

#define	E_UNKNOWN	0
#define	E_SIZES		1
#define	E_BOUNDS	2
#define	E_MEM		3
#define	E_SING		4
#define	E_POSDEF	5
#define	E_FORMAT	6
#define	E_INPUT		7
#define	E_NULL		8
#define	E_SQUARE	9
#define	E_RANGE		10
#define	E_INSITU2	11
#define	E_INSITU	12
#define	E_ITER		13
#define	E_CONV		14
#define	E_START		15
#define	E_SIGNAL	16
#define	E_INTERN	17

/* error catching macros */
#define	catch(errnum,ok_part,err_part)	\
	{	jmp_buf _save;	int _err_num, _old_flag; \
		_old_flag = set_err_flag(EF_SILENT); \
		mem_copy(restart,_save,sizeof(jmp_buf)); \
		if ( (_err_num=setjmp(restart)) == 0 ) \
		{	ok_part; \
			set_err_flag(_old_flag); \
			mem_copy(_save,restart,sizeof(jmp_buf));	} \
		else if ( _err_num == errnum ) \
		{	set_err_flag(_old_flag);  \
			mem_copy(_save,restart,sizeof(jmp_buf)); \
			err_part;	} \
		else {	set_err_flag(_old_flag); \
			mem_copy(_save,restart,sizeof(jmp_buf)); \
			error(_err_num,"???() and catch"); \
		} \
	}
#define	catchall(ok_part,err_part) \
	{	jmp_buf _save;	int _err_num, _old_flag; \
		_old_flag = set_err_flag(EF_SILENT); \
		mem_copy(restart,_save,sizeof(jmp_buf)); \
		if ( (_err_num=setjmp(restart)) == 0 ) \
		{	ok_part; \
			set_err_flag(_old_flag); \
			mem_copy(_save,restart,sizeof(jmp_buf));	} \
		else \
		{	set_err_flag(_old_flag);  \
			mem_copy(_save,restart,sizeof(jmp_buf)); \
			err_part;	} \
	}
#define	tracecatch(ok_part,function) \
	{	jmp_buf _save;	int _err_num, _old_flag; \
		_old_flag = set_err_flag(EF_JUMP); \
		mem_copy(restart,_save,sizeof(jmp_buf)); \
		if ( (_err_num=setjmp(restart)) == 0 ) \
		{	ok_part; \
			set_err_flag(_old_flag); \
			mem_copy(_save,restart,sizeof(jmp_buf));	} \
		else \
		{	set_err_flag(_old_flag);  \
			mem_copy(_save,restart,sizeof(jmp_buf)); \
			error(_err_num,function);	} \
	}


/* Dynamic memory allocation */
/* Should use freemat/vec/perm in programs instead of m/v/px_free()
	as this is considerably safer -- also provides a simple type check ! */
#ifndef ANSI_C
extern	VEC *get_vec(), *v_resize();
extern	MAT *get_mat(), *m_resize();
extern  S_MAT *get_s_mat();
extern	PERM *get_perm(), *px_resize();
extern	IVEC *get_ivec(), *iv_resize();
extern	m_free(),v_free(),px_free(),iv_free();
#else
extern	VEC *get_vec(int), *v_resize(VEC *,int);
extern	MAT *get_mat(int,int), *m_resize(MAT *,int,int);
extern  S_MAT *get_s_mat(int);
extern	PERM *get_perm(int), *px_resize(PERM *,int);
extern	IVEC *get_ivec(int), *iv_resize(IVEC *,int);
extern	m_free(MAT *),v_free(VEC *),px_free(PERM *),*iv_free(IVEC *);
#endif
#define	freemat(mat)	{ m_free(mat);	(mat)=(MAT *)NULL; }
#define freevec(vec)	{ v_free(vec);	(vec)=(VEC *)NULL; }
#define	freeperm(px)	{ px_free(px);	(px)=(PERM *)NULL; }
#define	freeivec(iv)	{ iv_free(iv);	(iv)=(IVEC *)NULL; }

/* Entry level access to data structures */
#define	v_entry(vec,i)	((i) < (vec)->dim) && (i) >= 0 ? (vec)->ve[i] : \
					ev_err("v_entry",10)
#define	v_set(vec,i,val) ((vec)->ve[i] = ((i) < (vec)->dim && (i) >= 0) ? \
		val : ev_err("v_set",10))
#define	m_entry(mat,i,j) ((i) < (mat)->m && (j) < (mat)->n && \
	(i)>=0 && (j)>=0 ? (mat)->me[i][j] : ev_err("m_entry",10))
#define	m_set(mat,i,j,val) ((mat)->me[i][j] = ((i) < (mat)->m && \
	(j) < (mat)->n && (i)>=0 && (j)>=0) ? val : ev_err("m_entry",10))

/* I/O routines */
#ifndef ANSI_C
extern	fout_vec(),fout_mat(),fout_perm(),fout_ivec();
extern	VEC *fin_vec();
extern	MAT *fin_mat();
extern	PERM *fin_perm();
extern	IVEC *fin_ivec();
extern	int fy_or_n(), fin_int(), yn_dflt(), skipjunk();
extern	double fin_double();
extern	MAT *m_save(), *m_load();
extern	VEC *v_save();
#else
int fout_vec(FILE *,VEC *),
	fout_mat(FILE *,MAT *),
	fout_perm(FILE *,PERM *);
void fout_ivec(FILE *,IVEC *);
VEC *fin_vec(FILE *,VEC *);
MAT *fin_mat(FILE *,MAT *);
PERM *fin_perm(FILE *,PERM *);
IVEC *fin_ivec(FILE *,IVEC *);
int fy_or_n(FILE *,char *), fin_int(FILE *,char *,int,int), yn_dflt(),
		skipjunk(FILE *);
double fin_double(FILE *,char *,double,double);
MAT *m_save(FILE *,MAT *,char *), *m_load(FILE *,char **);
VEC *v_save(FILE *,VEC *,char *);
#endif
#define	out_vec(vec)	fout_vec(stdout,vec)
#define	in_vec(vec)	fin_vec(stdin,vec)
#define	out_mat(mat)	fout_mat(stdout,mat)
#define	in_mat(mat)	fin_mat(stdin,mat)
#define	out_perm(px)	fout_perm(stdout,px)
#define	in_perm(px)	fin_perm(stdin,px)
#define	out_ivec(iv)	fout_ivec(stdout,iv)
#define	in_ivec(iv)	fin_ivec(stdin,iv)
#define	finput(fp,prompt,fmt,var) \
	( ( isatty(fileno(fp)) ? fprintf(stderr,prompt) : skipjunk(fp) ), \
							fscanf(fp,fmt,var) )
#define	input(prompt,fmt,var)	finput(stdin,prompt,fmt,var)
#define	fprompter(fp,prompt) \
	( isatty(fileno(fp)) ? fprintf(stderr,prompt) : skipjunk(fp) )
#define	prompter(prompt)	fprompter(stdin,prompt)
#define	y_or_n(s)	fy_or_n(stdin,s)
#define	in_int(s,lo,hi)	fin_int(stdin,s,lo,hi)
#define	in_double(s,lo,hi)	fin_double(stdin,s,lo,hi)

/* Copying routines */
#ifndef ANSI_C
extern	MAT	*_cp_mat();
extern	VEC	*_cp_vec();
extern	PERM	*cp_perm();
extern	IVEC	*cp_ivec();
#else
extern	MAT	*_cp_mat(MAT *,MAT *,int,int);
extern	VEC	*_cp_vec(VEC *,VEC *,int);
extern	PERM	*cp_perm(PERM *,PERM *);
extern	IVEC	*cp_ivec(IVEC *,IVEC *);
#endif
#define	cp_mat(in,out)	_cp_mat(in,out,0,0)
#define	cp_vec(in,out)	_cp_vec(in,out,0)

/* Initialisation routines */
#ifndef ANSI_C
extern	VEC     *zero_vec(), *rand_vec(), *ones_vec();
extern	MAT     *zero_mat(), *id_mat(), *rand_mat(), *ones_mat();
extern	PERM    *px_id();
#else
extern	VEC     *zero_vec(VEC *), *rand_vec(VEC *), *ones_vec(VEC *);
extern	MAT     *zero_mat(MAT *), *id_mat(MAT *), *rand_mat(MAT *),
						*ones_mat(MAT *);
extern	PERM    *px_id(PERM *);
#endif

/* Basic vector operations */
#ifndef ANSI_C
extern	VEC *sv_mlt(), *mv_mlt(), *vm_mlt(), *v_add(), *v_sub(),
		*px_vec(), *pxinv_vec(), *v_mltadd(), *v_map(), *_v_map(),
		*v_lincomb(), *v_linlist();
extern	double _in_prod(), __ip__();
extern	void	__mltadd__(), __add__(), __sub__(), __zero__();
#else
extern	VEC	*sv_mlt(double,VEC *,VEC *),
		*mv_mlt(MAT *,VEC *,VEC *),
		*vm_mlt(MAT *,VEC *,VEC *),
		*v_add(VEC *,VEC *,VEC *), *v_sub(VEC *,VEC *,VEC *),
		*px_vec(PERM *,VEC *,VEC *),
		*pxinv_vec(PERM *,VEC *,VEC *),
		*v_mltadd(VEC *,VEC *,double,VEC *),
		*v_map(double (*f)(double),VEC *,VEC *),
		*_v_map(double (*f)(void *,double),void *,VEC *,VEC *),
		*v_lincomb(int,VEC **,double *,VEC *), *v_linlist();
extern	double	_in_prod(VEC *,VEC *,int), __ip__(double *,double *,int);
extern	void	__mltadd__(double *,double *,double,int),
		__add__(double *,double *,int),
		__sub__(double *,double *,int),
		__zero__(double *,int);
#endif
#define	in_prod(a,b)	_in_prod(a,b,0)

/* Norms */
#ifndef ANSI_C
extern	double	_v_norm1(), _v_norm2(), _v_norm_inf(),
		m_norm1(), m_norm_inf(), m_norm_frob();
#else
extern	double	_v_norm1(VEC *,VEC *), _v_norm2(VEC *,VEC *),
		_v_norm_inf(VEC *,VEC *),
		m_norm1(MAT *), m_norm_inf(MAT *), m_norm_frob(MAT *);
#endif
#define	v_norm1(x)	_v_norm1(x,VNULL)
#define	v_norm2(x)	_v_norm2(x,VNULL)
#define	v_norm_inf(x)	_v_norm_inf(x,VNULL)

/* Basic matrix operations */
#ifndef ANSI_C
extern	MAT *sm_mlt(), *m_mlt(), *mmtr_mlt(), *mtrm_mlt(), *m_add(),
		*sub_mat(), *m_transp(), *ms_mltadd();
extern	MAT *px_rows(), *px_cols(), *swap_rows(), *swap_cols();
extern	VEC *get_row(), *get_col(), *_set_row(), *_set_col(), *sub_vec(),
		*mv_mltadd(), *vm_mltadd();
#else
extern	MAT	*sm_mlt(double,MAT *,MAT *),
		*m_mlt(MAT *,MAT *,MAT *),
		*mmtr_mlt(MAT *,MAT *,MAT *),
		*mtrm_mlt(MAT *,MAT *,MAT *),
		*m_add(MAT *,MAT *,MAT *),
		*sub_mat(MAT *,MAT *,MAT *),
		*m_transp(MAT *,MAT *),
		*ms_mltadd(MAT *,MAT *,double,MAT *);
extern	MAT	*px_rows(PERM *,MAT *,MAT *),
		*px_cols(PERM *,MAT *,MAT *),
		*swap_rows(MAT *,int,int,int,int),
		*swap_cols(MAT *,int,int,int,int);
extern	VEC	*get_row(MAT *,int,VEC *),
		*get_col(MAT *,int,VEC *),
		*_set_row(MAT *,int,VEC *,int),
		*_set_col(MAT *,int,VEC *,int),
		*sub_vec(VEC *,int,int,VEC *),
		*mv_mltadd(VEC *,VEC *,MAT *,double,VEC *),
		*vm_mltadd(VEC *,VEC *,MAT *,double,VEC *);
#endif
#define	set_row(mat,row,vec)	_set_row(mat,row,vec,0)
#define	set_col(mat,col,vec)	_set_col(mat,col,vec,0)

/* Basic permutation operations */
#ifndef ANSI_C
extern	PERM *px_mlt(), *px_inv(), *trans_px();
extern	int  sign_px();
#else
extern	PERM	*px_mlt(PERM *,PERM *,PERM *),
		*px_inv(PERM *,PERM *),
		*trans_px(PERM *,int,int);
extern	int	sign_px(PERM *);
#endif

/* Basic integer vector operations */
#ifndef ANSI_C
extern	IVEC	*iv_add(), *iv_sub();
#else
extern	IVEC	*iv_add(IVEC *,IVEC *,IVEC *),
		*iv_sub(IVEC *,IVEC *,IVEC *);
#endif

/* miscellaneous functions */
#ifndef ANSI_C
extern	double	square(), cube();
#else
extern	double	square(double), cube(double);
#endif

/* miscellaneous constants */
#define	VNULL	((VEC *)NULL)
#define	MNULL	((MAT *)NULL)
#define	PNULL	((PERM *)NULL)
#define	IVNULL	((IVEC *)NULL)
extern	char	*format;

#endif


/*
	Header file for ``matrix2.a'' library file
	(C) Copyright David Stewart 3rd Dec 1987
*/

/* should come after #include "matrix.h"	*/

#ifndef ANSI_C
extern	MAT	*BKPfactor(), *CHfactor(), *LUfactor(), *QRfactor(),
		*QRCPfactor(), *LDLfactor(), *Hfactor(), *MCHfactor();
extern	double	LUcondest();
extern	MAT	*makeQ(), *makeR(), *makeHQ(), *makeH();
extern	MAT	*LDLupdate(), *QRupdate();

extern	VEC	*BKPsolve(), *CHsolve(), *LUsolve(), *_Qsolve(), *QRsolve(),
		*LDLsolve(), *Usolve(), *Lsolve(), *Dsolve(), *LTsolve(),
		*UTsolve();

extern	VEC	*hhvec();
extern	VEC	*hhtrvec();
extern	MAT	*hhtrrows();
extern	MAT	*hhtrcols();

extern	givens();
extern	VEC	*rot_vec();	/* in situ */
extern	MAT	*rot_rows();	/* in situ */
extern	MAT	*rot_cols();	/* in situ */

/* eigenvalue routines */
extern	VEC	*trieig(), *symmeig();
extern	MAT	*schur();
extern	void	schur_evals();
extern	MAT	*schur_vecs();

/* singular value decomposition */
extern	VEC	*bisvd(), *svd();
#else

extern	MAT	*BKPfactor(MAT *,PERM *,PERM *),
		*CHfactor(MAT *), *LUfactor(MAT *,PERM *),
		*QRfactor(MAT *,VEC *,VEC *),
		*QRCPfactor(MAT *,VEC *,VEC *,PERM *),
		*LDLfactor(MAT *), *Hfactor(MAT *,VEC *,VEC *),
                *MCHfactor(MAT *,double);
extern	double	LUcondest(MAT *,PERM *);
extern	MAT	*makeQ(MAT *,VEC *,VEC *,MAT *),
		*makeR(MAT *,MAT *),
		*makeHQ(MAT *,VEC *,VEC *,MAT *),
		*makeH(MAT *,MAT *);
extern	MAT	*LDLupdate(MAT *,VEC *,double),
		*QRupdate(MAT *,MAT *,VEC *,VEC *);

extern	VEC	*BKPsolve(MAT *,PERM *,PERM *,VEC *,VEC *),
		*CHsolve(MAT *,VEC *,VEC *),
		*LDLsolve(MAT *,VEC *,VEC *),
		*LUsolve(MAT *,PERM *,VEC *,VEC *),
		*_Qsolve(MAT *,VEC *,VEC *,VEC *,VEC *, VEC *),
		*QRsolve(MAT *,VEC *,VEC *,VEC *,VEC *),

		*Usolve(MAT *,VEC *,VEC *,double),
		*Lsolve(MAT *,VEC *,VEC *,double),
		*Dsolve(MAT *,VEC *,VEC *),
		*LTsolve(MAT *,VEC *,VEC *,double),
		*UTsolve(MAT *,VEC *,VEC *,double);

extern	VEC	*hhvec(VEC *,int,double *,VEC *,double *);
extern	VEC	*hhtrvec(VEC *,double,int,VEC *,VEC *);
extern	MAT	*hhtrrows(MAT *,int,int,VEC *,double);
extern	MAT	*hhtrcols(MAT *,int,int,VEC *,double);

extern	givens(double,double,double *,double *);
extern	VEC	*rot_vec(VEC *,int,int,double,double,VEC *);	/* in situ */
extern	MAT	*rot_rows(MAT *,int,int,double,double,VEC *);	/* in situ */
extern	MAT	*rot_cols(MAT *,int,int,double,double,VEC *);	/* in situ */

/* eigenvalue routines */
extern	VEC	*trieig(VEC *,VEC *,MAT *),
		*symmeig(MAT *,MAT *,VEC *);
extern	MAT	*schur(MAT *,MAT *);
extern	void	schur_evals(MAT *,VEC *,VEC *);
extern	MAT	*schur_vecs(MAT *T,MAT *Q,MAT *X_re,MAT *X_im);

/* singular value decomposition */
VEC	*bisvd(VEC *,VEC *,MAT *,MAT *),
	*svd(MAT *,MAT *,MAT *,VEC *);
#endif




#ifndef ANSI_C
MAT *v_diag();
#else
MAT *v_diag(VEC * mu, MAT *out);
#endif


