/* Any machine specific stuff goes here */
/* Add details necessary for your own installation here! */

#ifndef MACHINE_H
#define MACHINE_H




/* Note special macros: ANSI_C (ANSI C syntax)
			SEGMENTED (segmented memory machine e.g. MS-DOS)
			MALLOCDECL (declared if malloc() etc have
					been declared) */


/*--------BSD 4.2 & 4.3, Symmetry-DYNIX, SUN, DEC 5000*/
#if defined(SUN) || defined(DYNIX) || defined(DEC5000) || defined(HP9000) || defined(NEXT)
#if defined(ANSI_C)
#ifndef MALLOCDECL
#define MALLOCDECL 1
#endif
#endif
typedef	unsigned int	u_int;
#define	mem_copy(from,to,size)	bcopy((char *)(from),(char *)(to),(int)(size))
#define	mem_zero(where,size)	bzero((char *)(where),(int)(size))
#endif /* BSD4[23] */

/*      TURBO C */
#if defined(TURBOC) 
#if defined(ANSI_C)
#ifndef MALLOCDECL
#define MALLOCDECL 1
#endif
#endif
typedef	unsigned int	u_int;
#define mem_copy(from,to,size)  memmove((to),(from),(size))
#define mem_zero(where,size)    memset((where),'\0',(size))
#endif /* TURBO C */

#if defined(RISC6000) 
#ifndef ANSI_C
#define ANSI_C 1
#endif
#ifndef MALLOCDECL
#define MALLOCDECL 1
#endif
#define	mem_copy(from,to,size)	bcopy((char *)(from),(char *)(to),(int)(size))
#define	mem_zero(where,size)	bzero((char *)(where),(int)(size))
#endif /* RISC6000 */

/*-----------------------RISC6000, XLC---------------------------*/
#if defined (XLC)
#ifndef ANSI_C
#define ANSI_C 1
#endif
#ifndef MALLOCDECL
#define MALLOCDECL 1
#endif
typedef unsigned int    u_int;
#define mem_copy(from,to,size)  memmove((to),(from),(size))
#define mem_zero(where,size)    memset((where),'\0',(size))
#define MAX_RAND        32757.0
#endif /* XLC */


/*----------------------- DJGPP Compiler ---------------------------*/
#if defined(DJGPP)
#ifndef ANSI_C
#define ANSI_C 1
#endif
#ifndef MALLOCDECL
#define MALLOCDECL 1
#endif
#include	<stddef.h> 
typedef	unsigned int	u_int;
#define	mem_copy(from,to,size)	memmove((to),(from),(size))
#define	mem_zero(where,size)	memset((where),'\0',(size))
#define	MAX_RAND	32757.0
#endif /* END GCC */

/* machine epsilon or unit roundoff error */
/* This is correct on most IEEE double precision systems */
#ifdef DBL_EPSILON
#define	MACHEPS	DBL_EPSILON
#endif
#ifndef MACHEPS
#define	MACHEPS	2.2e-16
#endif
#ifndef MAX_RAND
#define	MAX_RAND 2.147483648e9
#endif
/* for non-ANSI systems */
#ifndef HUGE_VAL
#define HUGE_VAL HUGE
#endif




#endif /* MACHINE_H */

