#include <math.h>
#include "bnet-uti.h"

real norm( x, y,n)
     real  *x, *y;
     int n;
{
  int i;
  real sum =0.0;

  for ( i =1; i<=n; i++)
    sum += (real) fabs((double)(x[i]-y[i]));
  return (sum);
}


void lubksb(a,n,indx,b)
     real **a,b[];
     int n,*indx;
{
  int i,ii=0,ip,j;
  real sum;
  
  for (i=1;i<=n;i++) {
    ip=indx[i];
    sum=b[ip];
    b[ip]=b[i];
    if (ii)
      for (j=ii;j<=i-1;j++) sum -= a[i][j]*b[j];
    else if (sum) ii=i;
    b[i]=sum;
  }
  for (i=n;i>=1;i--) {
    sum=b[i];
    for (j=i+1;j<=n;j++) sum -= a[i][j]*b[j];
    b[i]=sum/a[i][i];
  }
}


#define TINY 1.0e-20;

void ludcmp(a,n,indx,d)
     int n,*indx;
     real **a,*d;
{
  int i,imax,j,k;
  real big,dum,sum,temp;
  real *vv,*dvector();
  extern void Bneterror(),free_dvector();

  vv=dvector(1,n);
  *d=1.0;
  for (i=1;i<=n;i++) {
    big=0.0;
    for (j=1;j<=n;j++)
      if ((temp= (real) fabs((double)a[i][j])) > big) big=temp;
    if (big == 0.0) Bneterror("Singular matrix in routine LUDCMP");
    vv[i]=1.0/big;
  }
  for (j=1;j<=n;j++) {
    for (i=1;i<j;i++) {
      sum=a[i][j];
      for (k=1;k<i;k++) sum -= a[i][k]*a[k][j];
      a[i][j]=sum;
    }
    big=0.0;
    for (i=j;i<=n;i++) {
      sum=a[i][j];
      for (k=1;k<j;k++)
	sum -= a[i][k]*a[k][j];
      a[i][j]=sum;
      if ( (dum=vv[i]* (real) fabs((double)sum)) >= big) {
	big=dum;
	imax=i;
      }
    }
    if (j != imax) {
      for (k=1;k<=n;k++) {
	dum=a[imax][k];
	a[imax][k]=a[j][k];
	a[j][k]=dum;
      }
      *d = -(*d);
      vv[imax]=vv[j];
    }
    indx[j]=imax;
    if (a[j][j] == 0.0) a[j][j]=TINY;
    if (j != n) {
      dum=1.0/(a[j][j]);
      for (i=j+1;i<=n;i++) a[i][j] *= dum;
    }
  }
  free((char *) vv+1);
}

#undef TINY

void mprove(a,alud,n,indx,b,x)
     real **a,**alud,b[],x[];
     int n,indx[];
{
  int j,i;
  real sdp;
  real *r,*dvector();
  void lubksb(),free_dvector();
  
  r=dvector(1,n);
  for (i=1;i<=n;i++) {
    sdp = -b[i];
    for (j=1;j<=n;j++) sdp += a[i][j]*x[j];
    r[i]=sdp;
  }
  lubksb(alud,n,indx,r);
  for (i=1;i<=n;i++) x[i] -= r[i];
  free((char *) r+1);
}


real *ludeq1f(a, b, n)
     real **a, *b;
     int n;
{
  real *x, **alud,  garb;
  int *indx, i, j;
  extern real *dvector();
  extern int *ivector();
  extern real **dmatrix();
  extern void ludcmp();
  extern void lubsb();
  extern void free_dmatrix();
  extern void free_ivector();

  alud = dmatrix(1, n, 1, n);
  for ( i =1; i<=n; i++) for ( j =1; j<=n; j++)
    alud[i][j] = a[i][j];
  
  indx = ivector(1, n);
  ludcmp(alud, n, indx, &garb);
  x  = dvector(1, n);
  for ( i =1 ; i<=n; i++)
    x[i] = b[i];
  lubksb(alud, n, indx, x);
  free((char *)indx+1);
  free_dmatrix(alud, 1, n,  1);
  return ( x );
}
 
#define BIGNUMBER             1000
#define EPS                   (1.0e-10)
real *ludeq2f(a, b, n, count) 
     /* high accucary linear eqaution solver using LUD  and improvement 
      */
     real **a, *b;
     int n , *count;
{
  real *x, **alud, *ax, norm(),  garb;
  int *indx, i, j;
  extern real *dvector();
  extern int  *ivector();
  extern real **dmatrix();
  extern void ludcmp();
  extern void lubsb();
  extern void free_dmatrix();
  extern void free_ivector();
  extern void Bneterror();
  extern void mprove();

  *count = 0;
  alud = dmatrix(1, n, 1, n);
  for ( i =1; i<=n; i++) for ( j =1; j<=n; j++)
    alud[i][j] = a[i][j];
  
  indx = ivector(1, n);
  ludcmp(alud, n, indx, &garb);
  x  = dvector(1, n);
  for ( i =1 ; i<=n; i++)
    x[i] = b[i];
  lubksb(alud, n, indx, x);
  ax  = dvector(1, n);
  for (i =1; i<=n; i++)  {
    ax[i] = 0.0;
    for ( j = 1; j<=n; j++)
      ax[i] += a[i][j] * x[j];
  }
  while  ( norm( b, ax, n) > EPS && (*count)++<BIGNUMBER )  {
   mprove(a, alud, n, indx, b, x);
   for (i =1; i<=n; i++)  {
     ax[i] = 0.0;
     for ( j = 1; j<=n; j++)
       ax[i] += a[i][j] * x[j];
   }
 }
  if ( *count >=BIGNUMBER ) Bneterror("leq can not be improved");
  free((char *) indx+1);
  free_dmatrix(alud, 1, n,  1);
  return ( x );
}
 
#undef EPS
#undef BIGNUMBER






void gaxpy_cholesky_1(A, n)
     real **A;
     int n;
{
  int i, j, k;
  real tmp;

  for (j=1; j<=n; j++) {
    if (j>1)
      for (i=j; i<=n; i++)
	for (k=1; k<j; k++)
	  A[i][j] -= A[i][k] * A[j][k];
    tmp = (real) sqrt((double)A[j][j]);
    for (i=j; i<=n; i++) 
            A[i][j] /= tmp;
  }
}
    
void fwsub(A, b, n)
     real **A, *b;
     int n;
{

  int i, j;
  
  for (i=1; i<=n; i++) { 
    for (j=1; j<i; j++)
      b[i] -= A[i][j] * b[j];
    b[i] /= A[i][i];
  }
}


void bksub(A, b, n)
     real **A, *b;
     int n;
{
  int i, j;

    
  for (i=n; i; i--) {
    for (j=i+1; j<=n; j++)
      b[i] -= A[j][i] * b[j];
    b[i] /= A[i][i];
  }
}

void matrix_inversion( a, y, d)
     real **a, **y;
     int d;
{
  real **alud, *col, *dvector(), **dmatrix(), dd;
  int i, j, *indx, *ivector();
  void free_ivector(), free_dvector(), free_dmatrix();
  void ludcmp(), lubksb();

  col = dvector(1, d);
  indx = ivector(1, d);
  alud = dmatrix(1,d, 1,d);

  for ( i =1; i<=d; i++) for ( j =1; j<=d; j++)
    alud[i][j] = a[i][j];
  ludcmp(alud, d, indx, &dd);
  for ( j =1; j<=d; j++) {
    for ( i=1; i<=d; i++) col[i] = 0.0;
    col[j] = 1.0;
    lubksb(alud, d, indx, col);
    for ( i =1 ; i<=d; i++) y[i][j] = col[i];
  }
  free_dmatrix( alud, 1, d, 1);
  free((char *) col+ 1);
  free((char *)indx+1);
}

void gaxpy_cholesky(A, n)
     real **A;
     int n;
{
  int i, j, k;
  real tmp;
  real **Ai, **Aj;

  tmp = (real) sqrt((double)A[1][1]);
  for (i=n, Ai=A+n; i; i--, Ai--)    (*Ai)[1] /= tmp;
  
  for (j=2, Aj=A+2; j<=n; j++, Aj++) {
    for (k= j-1; k; k--) 
      (*Aj)[j] -=  (*Aj)[k] * (*Aj)[k]; 
    tmp = (real) sqrt((double) (*Aj)[j]);
    (*Aj)[j] /= tmp;
    for (i=j+1, Ai=A+j+1; i<=n; i++, Ai++) {
      for (k=j-1; k; k--)
	(*Ai)[j] -=  (*Ai)[k] * (*Aj)[k];
      (*Ai)[j] /= tmp;
    }
  }
}


void print_matrix(A, d)
     int d;
     real **A;
     
{

  int i, j;

  for (i=1; i<=d; i++)
    {
      for (j=1; j<=d; j++) {
	printf("%6.3f ", A[i][j]);
	if (j%10==0)
	  printf(".. \n");
      }
      printf("\n");
    }
}
    

void print_lower_matrix(A, d)
     int d;
     real **A;
     
{

  int i, j;

  for (i=1; i<=d; i++)
    {
      for (j=1; j<=d; j++) {
	printf("%6.3f ", (j<=i)?A[i][j]:A[j][i]);
	if (j%10==0)
	  printf(".. \n");
      }
      printf("\n");
    }
}
    


void print_vector(b, n)
     int n;
     double *b;
     
{

  int i;
  
  printf("\n");
  for (i=1; i<=n; i++) {
    printf("%6.3f ", b[i]);
    if (i%10==0)
      printf(".. \n");
  }
  printf("\n");
}

