/*
	This is a file of routines for zero-ing, and initialising
	vectors, matrices and permutations.
	This is to be included in the matrix.a library
*/
/*	(C) Copyright David Stewart 1989	*/
static	char	rcsid[] = "$Header: /usr/local/home/des/meschach/meschach/RCS/init.c,v 1.2 1992/02/28 03:12:23 des Exp $";

#include	<stdio.h>
#include	"matdef.h"

/* zero_vec -- zero the vector x */
VEC	*zero_vec(x)
VEC	*x;
{
	if ( x == VNULL )
		error(E_NULL,"zero_vec");

	__zero__(x->ve,x->dim);
	/* for ( i = 0; i < x->dim; i++ )
		x->ve[i] = 0.0; */

	return x;
}

/* zero_mat -- zero the matrix A */
MAT	*zero_mat(A)
MAT	*A;
{
	int	i, A_m, A_n;
	double	**A_me;

	if ( A == MNULL )
		error(E_NULL,"zero_mat");

	A_m = A->m;	A_n = A->n;	A_me = A->me;
	for ( i = 0; i < A_m; i++ )
		__zero__(A_me[i],A_n);
		/* for ( j = 0; j < A_n; j++ )
			A_me[i][j] = 0.0; */

	return A;
}

/* mat_id -- set A to being closest to identity matrix as possible
	-- i.e. A[i][j] == 1 if i == j and 0 otherwise */
MAT	*id_mat(A)
MAT	*A;
{
	int	i, size;

	if ( A == MNULL )
		error(E_NULL,"id_mat");

	zero_mat(A);
	size = min(A->m,A->n);
	for ( i = 0; i < size; i++ )
		A->me[i][i] = 1.0;

	return A;
}
	
/* px_id -- set px to identity permutation */
PERM	*px_id(px)
PERM	*px;
{
	int	i, px_size;
	u_int	*px_pe;

	if ( px == PNULL )
		error(E_NULL,"px_id");

	px_size = px->size;	px_pe = px->pe;
	for ( i = 0; i < px_size; i++ )
		px_pe[i] = i;

	return px;
}

/* rand_vec -- initialises x to be a random vector, components
	independently & uniformly ditributed between 0 and 1 */
VEC	*rand_vec(x)
VEC	*x;
{
	int	i;

	if ( ! x )
		error(E_NULL,"rand_vec");

	for ( i = 0; i < x->dim; i++ )
		x->ve[i] = rand()/MAX_RAND;

	return x;
}

/* rand_mat -- initialises A to be a random vector, components
	independently & uniformly distributed between 0 and 1 */
MAT	*rand_mat(A)
MAT	*A;
{
	int	i, j;

	if ( ! A )
		error(E_NULL,"rand_mat");

	for ( i = 0; i < A->m; i++ )
		for ( j = 0; j < A->n; j++ )
		    A->me[i][j] = rand()/MAX_RAND;

	return A;
}

/* ones_vec -- fills x with one's */
VEC	*ones_vec(x)
VEC	*x;
{
	int	i;

	if ( ! x )
		error(E_NULL,"ones_vec");

	for ( i = 0; i < x->dim; i++ )
		x->ve[i] = 1.0;

	return x;
}

/* ones_mat -- fills matrix with one's */
MAT	*ones_mat(A)
MAT	*A;
{
	int	i, j;

	if ( ! A )
		error(E_NULL,"ones_mat");

	for ( i = 0; i < A->m; i++ )
		for ( j = 0; j < A->n; j++ )
		    A->me[i][j] = 1.0;

	return A;
}

