
/*
	File with basic error-handling operations
		Based on previous version on Zilog
		System 8000 setret() etc.
		Ported to Pyramid 9810 late 1987
*/
/*	(C) Copyright David Stewart 1987	*/
static	char	rcsid[] = "$Header: /usr/local/home/des/meschach/meschach/RCS/err.c,v 1.3 1991/11/11 06:35:55 des Exp $";

#include	<stdio.h>
#include	<setjmp.h>
#include	<ctype.h>

#ifdef SYSV
/* AT&T System V */
#include	<sys/signal.h>
#else
/* something else -- assume BSD or ANSI C */
#include	<signal.h>
#endif

#define		FALSE	0
#define		TRUE	1

#define	EF_EXIT		0
#define	EF_ABORT	1
#define	EF_JUMP		2
#define	EF_SILENT	3

/* The only error caught in this file! */
#define	E_SIGNAL	16

static	char	*err_mesg[] =
		{	"unknown error",			/* 0 */
			"sizes of objects don't match",		/* 1 */
			"index out of bounds",			/* 2 */
			"can't allocate memory",		/* 3 */
			"singular matrix",			/* 4 */
			"matrix not positive definite",		/* 5 */
			"incorrect format input",		/* 6 */
			"bad input file/device",		/* 7 */
			"NULL objects passed",			/* 8 */
			"matrix not square",			/* 9 */
			"object out of range",			/* 10 */
			"can't do operation in situ for non-square matrix",
			"can't do operation in situ",		/* 12 */
			"excessive number of iterations",	/* 13 */
			"convergence criterion failed",		/* 14 */
			"bad starting value",			/* 15 */
			"floating exception",			/* 16 */
			"internal inconsistency (data structure)"/* 17 */
		};

#define	MAXERR	(sizeof(err_mesg)/sizeof(char *)-1)
#define	MAX_ERRS	100

jmp_buf	restart;

static	int	err_flag = EF_EXIT, num_errs = 0, cnt_errs = 1;

/* set_err_flag -- sets err_flag -- returns old err_flag */
int	set_err_flag(flag)
int	flag;
{
	int	tmp;

	tmp = err_flag;
	err_flag = flag;
	return tmp;
}

/* count_errs -- sets cnt_errs (TRUE/FALSE) & returns old value */
int	count_errs(flag)
int	flag;
{
	int	tmp;

	tmp = cnt_errs;
	cnt_errs = flag;
	return tmp;
}

/* ev_err -- reports error (err_num) in file "file" at line "line_num" and
		returns to user error handler */
ev_err(file,err_num,line_num,fn_name)
char	*file, *fn_name;
int	err_num, line_num;
{
	int	num;

	if ( err_num < 0 ) err_num = 0;

	num = err_num;
	if ( num > MAXERR ) num = 0;

	if ( cnt_errs && ++num_errs >= MAX_ERRS )	/* too many errors */
	{
		fprintf(stderr,"\n\"%s\", line %d: %s in function %s()\n",
			file,line_num,err_mesg[num],
			isascii(*fn_name) ? fn_name : "???");
		if ( ! isatty(fileno(stdout)) )
		    fprintf(stdout,"\n\"%s\", line %d: %s in function %s()\n",
			file,line_num,err_mesg[num],
			isascii(*fn_name) ? fn_name : "???");
		printf("Sorry, too many errors: %d\n",num_errs);
		printf("Exiting program\n");
		exit(0);
	}

	switch ( err_flag )
	{
	case EF_SILENT:
		longjmp(restart,(err_num==0)? -1 : err_num);
		break;
	case EF_ABORT:
		fprintf(stderr,"\n\"%s\", line %d: %s in function %s()\n",
			file,line_num,err_mesg[num],
			isascii(*fn_name) ? fn_name : "???");
		if ( ! isatty(fileno(stdout)) )
		    fprintf(stdout,"\n\"%s\", line %d: %s in function %s()\n",
			file,line_num,err_mesg[num],
			isascii(*fn_name) ? fn_name : "???");
		abort();
		break;
	case EF_JUMP:
		fprintf(stderr,"\n\"%s\", line %d: %s in function %s()\n",
			file,line_num,err_mesg[num],
			isascii(*fn_name) ? fn_name : "???");
		if ( ! isatty(fileno(stdout)) )
		    fprintf(stdout,"\n\"%s\", line %d: %s in function %s()\n",
			file,line_num,err_mesg[num],
			isascii(*fn_name) ? fn_name : "???");
		longjmp(restart,(err_num==0)? -1 : err_num);
		break;
	default:
		fprintf(stderr,"\n\"%s\", line %d: %s in function %s()\n",
			file,line_num,err_mesg[num],
			isascii(*fn_name) ? fn_name : "???");
		if ( ! isatty(fileno(stdout)) )
		    fprintf(stdout,"\n\"%s\", line %d: %s in function %s()\n",
			file,line_num,err_mesg[num],
			isascii(*fn_name) ? fn_name : "???");
		printf("\nSorry, exiting program\n");
		exit(0);
		break;
	}

	/* ensure exit if fall through */
	exit(0);
}

/* float_error -- catches floating arithmetic signals */
static void	float_error(num)
int	num;
{
	signal(SIGFPE,float_error);
	/* fprintf(stderr,"SIGFPE: signal #%d\n",num); */
	/* fprintf(stderr,"errno = %d\n",errno); */
	ev_err("???.c",E_SIGNAL,0,"???");
}

/* catch_signal -- sets up float_error() to catch SIGFPE's */
void	catch_FPE()
{
	signal(SIGFPE,float_error);
}

