/*	(C) Copyright David Stewart 1989	*/
#include	<stdio.h>
#include	"matdef.h"

#ifdef ANSI_C
MAT	*get_mat(int,int), *m_resize(MAT *,int,int);
VEC	*get_vec(int), *v_resize(VEC *,int);
PERM	*get_perm(int), *px_resize(PERM *,int);
#else
extern	MAT	*get_mat(), *m_resize();
extern	VEC	*get_vec(), *v_resize();
extern	PERM	*get_perm(), *px_resize();
#endif

/* 1.3 copy.c 11/25/87 */
/* _cp_mat -- copies matrix into new area */
MAT	*_cp_mat(in,out,i0,j0)
MAT	*in,*out;
u_int	i0,j0;
{
	u_int	i,j;

	if ( in==(MAT *)NULL )
		error(E_NULL,"_cp_mat");
	if ( in==out )
		return (out);
	if ( out==(MAT *)NULL || out->m < in->m || out->n < in->n )
		out = m_resize(out,in->m,in->n);

	for ( i=i0; i < in->m; i++ )
		mem_copy(&in->me[i][j0],&out->me[i][j0],
				(in->n - j0)*sizeof(double));
		/* for ( j=j0; j < in->n; j++ )
			out->me[i][j] = in->me[i][j]; */

	return (out);
}

/* _cp_vec -- copies vector into new area */
VEC	*_cp_vec(in,out,i0)
VEC	*in,*out;
u_int	i0;
{
	/* u_int	i,j; */

	if ( in==(VEC *)NULL )
		error(E_NULL,"_cp_vec");
	if ( in==out )
		return (out);
	if ( out==(VEC *)NULL || out->dim < in->dim )
		out = v_resize(out,in->dim);

	mem_copy(&in->ve[i0],&out->ve[i0],(in->dim - i0)*sizeof(double));
	/* for ( i=i0; i < in->dim; i++ )
		out->ve[i] = in->ve[i]; */

	return (out);
}

/* cp_perm -- copies permutation 'in' to 'out' */
PERM	*cp_perm(in,out)
PERM	*in,*out;
{
	/* int	i; */

	if ( in == (PERM *)NULL )
		error(E_NULL,"cp_perm");
	if ( in == out )
		return out;
	if ( out == (PERM *)NULL || out->size != in->size )
		out = px_resize(out,in->size);

	mem_copy(in->pe,out->pe,in->size*sizeof(u_int));
	/* for ( i = 0; i < in->size; i++ )
		out->pe[i] = in->pe[i]; */

	return out;
}

