#include <stdio.h>
#include "bnet-uti.h"

void Bneterror( text )
     char *text;
{

  (void) printf("Fatal error occured ......\n");
  (void) printf("%s\n" , text);
  (void) printf("Leaving system now ......\n");
  exit(0);
}

real **dmatrix(nrl, nrh, ncl, nch)
     int nrl, nrh, ncl, nch;
/* allocates  a    real matrix  with range [nrl...nrh][ncl...nch] */

{

  int i;
  real **m;
  extern void Bneterror();

  /*allocates pointers to row */
  m= ( real **) malloc((unsigned) (nrh-nrl + 1)*sizeof(real *));
  if (!m) Bneterror("alloacation failure 1 in dmnatrix()");
  m -= nrl;
  /* allocate rows and set pointers to them */
  for ( i = nrl; i<=nrh; i++)
    {
      m[i] =(real *) malloc((unsigned) (nch-ncl + 1) *sizeof(real));
      if(!m[i]) Bneterror("allocation failure 2 in dmatrix()");
      m[i] -= ncl;
    }
  return m;
}

real **cmatrix(nrl, nrh, ncl, nch)
     int nrl, nrh, ncl, nch;
/* allocates  a    real matrix  with range [nrl...nrh][ncl...nch] 
 and initialize to zero */

{

  int i;
  real **m;
  extern void Bneterror();

  /*allocates pointers to row */
  m= ( real **) calloc((unsigned) (nrh-nrl + 1), sizeof(real *));
  if (!m) Bneterror("alloacation failure 1 in cmatrix()");
  m -= nrl;
  /* allocate rows and set pointers to them */
  for ( i = nrl; i<=nrh; i++)
    {
      m[i] =(real *) calloc((unsigned) (nch-ncl + 1), sizeof(real));
      if(!m[i]) Bneterror("allocation failure 2 in cmatrix()");
      m[i] -= ncl;
    }
  return m;
}




int  **imatrix(nrl, nrh, ncl, nch)
     int nrl, nrh, ncl, nch;
/* allocates  a int matrix  with range [nrl...nrh][ncl...nch] */

{

  int i;
  int  **m;
  extern void Bneterror();

  /*allocates pointers to row */
  m= ( int **) malloc((unsigned) (nrh-nrl + 1)*sizeof(int *));
  if (!m) Bneterror("alloacation failure 1 in imatrix()");
  m -= nrl;

  /* allocate rows and set pointers to them */
  for ( i = nrl; i<=nrh; i++)
    {
      m[i] =(int *) malloc((unsigned) (nch-ncl + 1) *sizeof(int));
      if(!m[i]) Bneterror("allocation failure 2 in imatrix()");
      m[i] -= ncl;
    }
  return m;
}


int *ivector(nl, nh)
     int nl, nh;
/* allocate  a real vector with range [nl...nh] */
{
  int *v;
  extern void Bneterror();

  v=(int *) malloc((unsigned) (nh-nl+1) * sizeof( int ));
  if (!v) Bneterror("allocation failure in ivector()");
  return v-nl;
}



real *dvector(nl, nh)
     int nl, nh;
/* allocate  a real vector with range [nl...nh] */
{
  real *v;
  extern void Bneterror();

  v=(real *) malloc((unsigned) (nh-nl+1) * sizeof( real ));
  if (!v) Bneterror("allocation failure in dvector()");
  return v-nl;
}

real *cvector(nl, nh)
     int nl, nh;
/* allocate  a real vector with range [nl...nh] */
{
  real *v;
  extern void Bneterror();

  v=(real *) calloc((unsigned) (nh-nl+1), sizeof( real ));
  if (!v) Bneterror("allocation failure in cvector()");
  return v-nl;
}




void free_dmatrix(m, nrl, nrh,  ncl)
     real **m;
     int nrl, nrh,  ncl;
/* free a matrix allocated with dmatrix. */

{
  int i;

 
  for ( i=nrh; i>=nrl; i--) free((char*) ( m[i]+ncl));
  free((char*) (m+nrl));
}

void free_dvector(v,nl,nh)
double *v;
int nl,nh;
{
	free((char*) (v+nl));
}
