#include "bnet.h"
#include <math.h>

int **ComputeC(dd, nn)
     int dd, nn;
{
  int i, l;
  int combi();
  int **c;

  c = imatrix(0, dd, -1, nn);    /* make  c[d+1][n+2] matrix */
  for (l=0; l<=dd; l++) for (i = -1; i<= nn; i++)
    c[l][i] = combi(l, i);     /* c[l][-1] = 0 */
  return c;
}  

int combi(k, m)
     int k, m;
{
  double tmp_n=1; /* numerator    */
  double tmp_d=1; /* denorminator */
  int value;
  int i;

  if (m< 0)  value = 0;    else {
    for ( i=1; i<=k; i++){
      tmp_n *= (m+i);
      tmp_d *= i;
    }
    value = (int) (tmp_n/tmp_d);
  }
  return (value);
}

real     **ComputeWeight(mygamma, dd, nn)
     real *mygamma;
     int dd, nn;

{
  int i, l;
  long factorial();
  int twon;
  real **w;

  twon = 2 * nn;
  w = dmatrix(1, dd, 0, twon);
  for (l=1; l<=dd ; l++) for (i=0; i<= twon; i++)
    w[l][i] = factorial(i)/(real) pow((double) 2*mygamma[l], (double) i+1);
  return w;
}

long factorial( k)
     int k;
{
  int i;
  long  tmp = 1;


  for( i = 1; i<=k; i++)
    tmp = tmp * i;
  return(tmp);
}  

    

int **ComputeIndex(c, dim, n) 
     int dim;                  /* dim = d and d-1 */
     int **c, n;
{
  int  i, **II, *InverseIndex();            

  II = (int **) malloc((unsigned)c[dim][n]*sizeof(int *));
  II -= 1;
  for (i=1; i<=c[dim][n]; i++)   II[i] = InverseIndex(dim, i, c);
  return (II);
}

int *InverseIndex(dim, i, c)
     int dim, i;
     int **c;
{
  int j,  *k, *II;

  k = ivector(1, dim);
  for (j=dim; j>=1; j--) {
    k[j] = -1;   
    while(i>c[j][k[j]]) k[j]++;   /* linear search */
    i -= c[j][k[j]-1];
   }	
  II = ivector(0, dim);
  II[0] = k[dim];
  for(j=1; j<dim; j++)  II[j] = k[dim-j+1] - k[dim-j];
  II[dim] = k[1];
  k += 1;
  free((char *) k );
  return (II);
}  

long Index(dim, II, c)
     int dim, *II;
     int **c;
{
  long tmp=1;
  int l, k=II[0]-1;
  
  for (l=dim; l>=1; l--) {
    tmp += c[l][k]; 
    k -= II[dim-l+1];
  }
  return (tmp);
}
  
