#ifndef GJN_H
#define GJN_H  1

#include <stdio.h>
#include "matrix.h"

#ifndef True
#define True 1
#endif

#ifndef False
#define False 0
#endif

#ifndef ANSI_C

extern FILE **option();

extern void gjn_input();

extern void gjn_output();

extern int get_dimension();

#else

FILE **option(int argc,
	      char *argv[],
	      int *iterative,
	      int *interactive,
	      int *workload,
	      int *print);

void gjn_input(VEC * alpha,  /* exogeneous arrival rate */
	       VEC * sca,    /* SCV for inter-arrival time */
	       VEC * tau,    /* mean service times */
	       VEC * scs,    /* SCV for service times */
	       MAT * P,      /* routing matrix */
	       int d,        /* of stations */
	       int * n,      /* maximum degree to use */
	       int interactive, 
	       FILE *input_fp
	       );


void gjn_output(MAT * Gamma, 
		VEC * mu,
	        MAT * R,
		int d,
		int n,
		FILE * output_fp,
		VEC * rho
		);

int get_dimension(int interative,
		  FILE  * input_fp);

#endif
#endif
