


MCN(1)                   USER COMMANDS                     MCN(1)



NAME
     mcn -- multi-class network


SYNOPSIS
     mcn [-h] [-p] [-j] [-v] [datafile [output-file]]


DESCRIPTION
     mcn converts the data set describing  a  d-station  queueing
     network  model  to  the  data set describing a d-dimensional
     reflected Brownian motion.  The  reflected  Brownian  motion
     serves as an approximation to the so-called workload process
     of the original queueing network model. Its  data  set  (the
     output  of  mcn)  can  then  be used as input to the program
     _b_n_e_t(1), which does steady-state analysis of  the  reflected
     Brownian motion.

     The input data for mcn describe an open network model with d
     single-server  stations. To be more specific, it is a struc-
     tured multiclass model of the type described by Harrison and
     Nguyen  (1990)  in   section  5  of their paper. There are a
     number K of so-called customer classes (K must be  at  least
     as large as d, the number of service stations, and in appli-
     cations it is often much larger), each class has an external
     input  process  with  a general inter-arrival time distribu-
     tion, each class has a general  service  time  distribution,
     and  each  class is served at a unique station.  In general,
     the correspondence between customer classes and service sta-
     tions  is  many-to-one,  and the classes served at a station
     are called its "constituency".   Finally,  after  completing
     service,  customers  change  class  according  to  a  Markov
     switching matrix.

     The only input data required for mcn are the switching  pro-
     bability  matrix,  the first two moments of the interarrival
     time and service times distributions, and a matrix of  zeros
     and ones that specifies the server constituencies.  The out-
     put data are a covariance matrix,  a  drift  vector,  and  a
     reflection  matrix that describe the approximating reflected
     Brownian motion, plus the traffic intensities at  each  sta-
     tion.

OPTIONS
     -h   print a brief help message for using mcn.

     -p   print the input data from the network.

     -j   instruct mcn that the network under consideration is  a
          generalized  Jackson  network.  Therefore  "mcn  -j" is
          identical to "gjn".  See _g_j_n(1).




Sun Release 4.1      Last change: JUNE 1992                     1






MCN(1)                   USER COMMANDS                     MCN(1)



     -v   print the current version of mcn.


DATA FILE
     The data in a data file should  be  arranged  in  the  order
     listed  below.  The  data  for each class are in exactly the
     same format. Therefore only the format of data for  class  1
     is listed in detail.

     d    is an integer, the number of stations in the structured
          network.

     K    is an integer, the number of customer  classes  in  the
          structured network.

     data for class 1 customers

          alpha     is the exogenous arrival rate (reciprocal  of
                    the mean interarrival time) for the class. If
                    there are no exogenous arrival to the  class,
                    alpha is equal to zero.

          sca       is  the  squared  coefficient  of   variation
                    (variance over squared mean) for the interar-
                    rival time distribution  for  the  class.  If
                    there  are no exogenous arrival to the class,
                    sca is equal to zero.

          tau       is the mean service time for the class.

          scs       is the squared coefficient of  variation  for
                    the service time distribution for the class.

          constituency
                    is the station number that the  customers  in
                    this class will visit.

          P[1]      is the K-dimensional vector of routing proba-
                    bilities;  P[1][j]  is the probability that a
                    customer of class 1  finishing  service  will
                    become next a class j customer.

     data for class 2 customers

          alpha

          sca

          tau

          scs




Sun Release 4.1      Last change: JUNE 1992                     2






MCN(1)                   USER COMMANDS                     MCN(1)



          constituency

          P[2]

     ......

     data for class K customers

          alpha

          sca

          tau

          scs

          constituency

          P[K]

     n    is the maximum degree of polynomials used in bnet. If n
          is not specified by user, the default value is 4.

EXAMPLE OF A DATA FILE
     Suppose we have the following network of two queues in  tan-
     dem with two customer types.

                      A     _____         _____
                    ------>|     |------>|     |------>
                           |  1  |       |  2  |
                    ------>|_____|------>|_____|------>
                      B

     Both type A and type B  customers  visit  station  1  first.
     After  being  served  at station 1 they go to station 2, and
     after being served at station 2 they exit the system.

     For type A customers, assume that the interarrival time dis-
     tribution to station 1 is exponential (sca = 1.0) with aver-
     age arrival rate 0.6, the service time distribution at  sta-
     tion  1  is Erlang of order 2 (scs = 0.5) with mean 0.8, and
     the service time distribution at station  2  is  exponential
     (scs  =  1.0)  with  mean 0.9.  For type B customers, assume
     that the interarrival time  distribution  to  station  1  is
     exponential  (sca  = 1.0) with average arrival rate 0.5, the
     service time distribution at station 1 is  hyper-exponential
     of  order  2 (scs = 2.0) with mean 0.7, and the service time
     distribution at station 2 is exponential (scs  =  1.0)  with
     mean 0.8.

     Type A customers visiting station 1 are called class 1  cus-
     tomers,  and  those  visiting  station  2 are called class 2



Sun Release 4.1      Last change: JUNE 1992                     3






MCN(1)                   USER COMMANDS                     MCN(1)



     customers. Similarly, type B customers  visiting  station  1
     are  called  class 3 customers, and those visiting station 2
     are called class  4  customers.  Therefore,  there  are  K=4
     classes  of  customers  in  the  network.  Station 1 will be
     visited by class 1 and class 3 customers only, and Station 2
     will  be  visited by class 2 and class 3 customers only. The
     data file for this multi-class open queueing network  is  as
     follows  (only  the  numbers  are part of the data file, the
     rest is descriptions):

      2              d               - number of stations
      4              K               - number of classes
                                     - data for class 1 customers
      0.6            alpha
      1              sca
      0.8            tau
      0.5            scs
      1              constituency
      0  1  0  0     P[1]
                                     - data for class 2 customers
      0              alpha
      0              sca
      0.9            tau
      1.0            scs
      2              constituency
      0  0  0  0     P[2]
                                      - data for class  3  custo-
     mers
      0.5            alpha
      1              sca
      0.7            tau
      2.0            scs
      1              constituency
      0  0  0  1     P[3]
                                    - data for class 4 customers
      0              alpha
      0              sca
      0.8            tau
      1              scs
      2              constituency
      0  0  0  0     P[4]

      5              n               - maximum degree

USAGE
     mcn is a front end routine for _b_n_e_t(1).   The  two  programs
     together  can  be  used for performance analysis of a struc-
     tured multi-class queueing network. Typically, one would use
     the UNIX pipe command as follows.

     "mcn queueing-data | bnet"




Sun Release 4.1      Last change: JUNE 1992                     4






MCN(1)                   USER COMMANDS                     MCN(1)



     In the line above, "|" is the UNIX pipe command. The command
     before  the pipe (mcn queueing-data) will produce bnet data,
     which immediately pipes into bnet as input.

     The output from bnet is the  mean  position  vector  of  the
     corresponding  reflected  Brownian motion. When the data for
     bnet are the output from mcn, the mean  position  vector  is
     interpreted  as  the  estimate  of the average waiting times
     (excluding the service  times)  at  stations  1,...,d.   For
     example,  a  run of "mcn queueing-data | bnet" with the data
     above will produce the following output:

                  FINAL RESULTS

              mean [1] =  3.855882
              mean [2] = 13.584370

     Therefore, our estimate of the average waiting time at  sta-
     tion 1 is 3.86 and that at station 2 is 13.58.


LIMITATIONS
     There are now known to be multi-class networks for which the
     corresponding  Brownian models do not exist.  That is, there
     are known to be multi-class networks for which the  Brownian
     approximation  proposed  by  Harrison and Nguyen (1990) does
     not make sense. For the following two special kinds of  net-
     works,  the  Brownian approximation should work well. One is
     the so-called feedforward  network,  where  Peterson  (1991)
     proved  a  heavy  traffic limit theorem. The other kind is a
     multiclass network, where all  classes  visiting  a  station
     have a common mean service time.


AUTHOR
     Jim  Dai,  School  of  Mathematics  and   Industrial/Systems
     Engineering, Georgia Institute of Technology, Atlanta, Geor-
     gia 30332, USA (dai@isye.gatech.edu)

SEE ALSO
     bnet(1), gjn(1)

     J. M. Harrison and V. Nguyen,  "The  QNET  method  for  two-
     moment  analysis  of  open queueing networks", Queueing Sys-
     tems: Theory and Applications Vol. 6, pp 1-32, 1990.

     W. Peterson, "A Heavy Traffic Limit Theorem for Networks  of
     Queues  with Multiple Customer Types", Mathematics of Opera-
     tions Research, Vol.16, pp.90-118, 1991.

     J. G. Dai and  W. Wang, "Nonexistence of Brownian models for
     certain  multiclass  networks", Queueing Systems: Theory and



Sun Release 4.1      Last change: JUNE 1992                     5






MCN(1)                   USER COMMANDS                     MCN(1)



     Applications, to appear.






















































Sun Release 4.1      Last change: JUNE 1992                     6



