


GJN(1)                   USER COMMANDS                     GJN(1)



NAME
     gjn -- generalized Jackson network

SYNOPSIS
     gjn [-h] [-q] [-p] [-v] [ _d_a_t_a_f_i_l_e [ _o_u_t_p_u_t-_f_i_l_e]]

DESCRIPTION
     A generalized Jackson network is a particular type of queue-
     ing  network  model  (see  below). gjn converts the data set
     describing a d-station generalized Jackson  network  to  the
     data  set  describing  a  d-dimensional  reflected  Brownian
     motion. The reflected Brownian motion serves as an  approxi-
     mation  to  the  so-called  workload  process  (or the queue
     length process, see the -q option  below)  of  the  original
     queueing network model. Its data set (the output of gjn) can
     then be used as input to the  program  _b_n_e_t(1),  which  does
     steady-state analysis of the reflected Brownian motion.

     The input data for gjn describe an open network model with d
     single-server  stations,  an  external input process to each
     station that has a general inter-arrival time  distribution,
     a  general  service  time  distribution at each station, and
     Markovian  switching  between  stations.  Only  the  routing
     matrix  (that  is, the switching probability matrix) and the
     first two moments of the inter-arrival time and service time
     distributions  are  required  as input data. The output data
     are a covariance matrix, a drift  vector  and  a  reflection
     matrix  that  describe  the approximating reflected Brownian
     motion, plus the traffic intensities at each station.

OPTIONS
     -h   print a brief help message for using gjn.

     -q   use the queue length formulation, instead of the  work-
          load  formulation described above. When -q is used, the
          output from bnet should  be  interpreted  as  the  mean
          queue  length  (including those being serviced) at each
          station.

     -p   print the original queueing network data.

     -v   print the current version of gjn.

DATA FILE
     The data in a data file should  be  arranged  in  the  order
     listed  below.  The data for each station are in exactly the
     same format. Therefore only the format of data at station  1
     is listed in detail.

     d    is an integer, the number of stations in  the  general-
          ized Jackson network.




Sun Release 4.1      Last change: JUNE 1992                     1






GJN(1)                   USER COMMANDS                     GJN(1)



     data at station 1

          alpha     is the exogenous arrival rate (reciprocal  of
                    the  mean inter-arrival time) to the station.
                    If there are no  exogenous  arrivals  to  the
                    station, alpha is equal to zero.

          sca       is  the  squared  coefficient  of   variation
                    (variance  over squared mean) of the interar-
                    rival time distribution for the  station.  If
                    there  are  no exogenous arrivals to the sta-
                    tion, sca is equal to zero.

          tau       is the mean service time at the station.

          scs       is the squared coefficient of  variation  for
                    the service time distribution at the station.

          P[1]      is  a  d-dimensional  vector  describing  the
                    routing  probabilities; P[1][j] is the proba-
                    bility that a customer finishing at station 1
                    will go next to station j.

     data at station 2

          alpha

          sca

          tau

          scs

          P[2]

     ......

     data at station d

          alpha

          sca

          tau

          scs

          P[d]

     n    is the maximum degree of polynomials used in bnet. If n
          is not specified by user, the default value is 4.




Sun Release 4.1      Last change: JUNE 1992                     2






GJN(1)                   USER COMMANDS                     GJN(1)



EXAMPLE OF A DATA FILE
     Suppose we have the following network of two queues in  tan-
     dem.
                            _____         _____
                           |     |       |     |
                    ------>|  1  |------>|  2  |------>
                           |_____|       |_____|

     Assume that the interarrival time distribution at station  1
     is  exponential  (sca  = 1.0)  with mean 1, the service time
     distribution at station 1 is Erlang of order 2 (scs  =  0.5)
     with  mean 0.8, and the service time distribution at station
     2 is exponential (scs = 1.0) with mean 0.9.  Then  the  data
     file  will  be the following: (only the numbers in the first
     two columns below are part of the data file,  the  rest  are
     descriptions)

      2              d               - number of stations
                                     - data at station 1
      1              alpha
      1              sca
      0.8            tau
      0.5            scs
      0     1        P[1]
                                     - data of station 2
      0              alpha
      0              sca
      0.9            tau
      1.0            scs
      0     0        P[2]

      6              n               - maximum degree

USAGE
     gjn is a front end routine for _b_n_e_t(1).   The  two  programs
     together  can be used for performance analysis of a general-
     ized Jackson network. Typically, one would use the UNIX pipe
     command as follows.

     "gjn queueing-data | bnet"

     In the line above, "|" is the UNIX pipe command. The command
     before  the pipe (gjn queueing-data) will produce bnet data,
     which immediately pipes into bnet as input.

     The output from bnet is the  mean  position  vector  of  the
     corresponding  reflected  Brownian motion. When the data for
     bnet are the output from gjn, the mean  position  vector  is
     interpreted  as  the  estimate  of the average waiting times
     (excluding the service  times)  at  stations  1,...,d.   For
     example,  a  run of "gjn queueing-data | bnet" with the data
     above will produce the following output:



Sun Release 4.1      Last change: JUNE 1992                     3






GJN(1)                   USER COMMANDS                     GJN(1)



                  FINAL RESULTS

              mean [1] = 2.400000
              mean [2] = 7.491756

     Therefore, our estimate of the average waiting time at  sta-
     tion 1 is 2.4 and that at station 2 is 7.49.

AUTHOR
     Jim  Dai,  School  of  Mathematics  and   Industrial/Systems
     Engineering, Georgia Institute of Technology, Atlanta, Geor-
     gia 30332, USA (dai@isye.gatech.edu)

SEE ALSO
     bnet(1), mcn(1)

     J. M. Harrison and V. Nguyen,  "The  QNET  method  for  two-
     moment  analysis  of open queueing networks", (Queueing Sys-
     tems: Theory and Applications Vol. 6, pp 1-32, 1990).




































Sun Release 4.1      Last change: JUNE 1992                     4



