


BNET(1)                  USER COMMANDS                    BNET(1)



NAME
     bnet -- Brownian network analyzer

SYNOPSIS
     bnet [-h] [-p] [-b] [-v] [datafile [output-file] ]

DESCRIPTION
     bnet  calculates  the  steady-state  mean  position   of   a
     reflected  Brownian  motion  Z  whose  state space is the d-
     dimensional non-negative orthant.  Such a stochastic process
     Z  may  be  used  to approximate the queue length process or
     workload process of a d-station open queueing  network,  cf.
     Harrison   and  Nguyen,  "The  QNET  Method  for  Two-Moment
     Analysis  of  Open  Queueing  Networks"  (Queueing  Systems,
     Vol.6,  pp.1-32, 1990).  This approximation is supported, at
     least for certain classes  of  networks,  by  heavy  traffic
     limit  theory: see Reiman's "Open Queueing Networks in Heavy
     Traffic"  (Mathematics  of   Operations   Research,   Vol.9,
     pp.441-458,  1984)  and  Peterson's  "A  Heavy Traffic Limit
     Theorem for Networks of Queues with Multiple Customer Types"
     (Mathematics  of  Operations  Research,  Vol.16,  pp.90-118,
     1991).

     The bnet program is a flexible tool for analysis of queueing
     networks,  but to use it for that purpose one needs a front-
     end routine that converts queueing system data to  the  data
     set  for  an approximating reflected Brownian motion; _g_j_n(1)
     performs this function for generalized Jackson networks, and
     _m_c_n(1) does it for multi-class networks.

     If no data file is given, bnet assumes that data comes  from
     standard  input.  By using the UNIX pipe command, the output
     from a front-end routine can directly be piped into bnet  as
     input data; see _g_j_n(1) and _m_c_n(1).

OPTIONS
     -h   print a brief help message for using bnet.

     -p   print the input data,  plus some intermediate data bnet
          uses.

     -b   use an alternative bnet linear solver.

     -v   print the current version of  bnet.

     These options can be separated or  grouped.  Therefore,  the
     command "bnet -b -p" is the same as "bnet -bp".

DATA FILE
     The format of the data file is as follows. The order of  the
     data is important.




Sun Release 4.1      Last change: JUNE 1992                     1






BNET(1)                  USER COMMANDS                    BNET(1)



     d    is  an integer, the dimension of the state space or the
          size of the corresponding queueing network.

     n    is an integer, the maximum degree of the  approximating
          polynomials.  The typical values for n are  4, 5, 6. In
          principle, larger values  increase  the  accuracy.  But
          they will certainly increase the running time too.

     Gamma
          is  a d times d real  matrix, the covariance matrix  of
          the  reflected Brownian motion. Only the _u_p_p_e_r triangu-
          lar part of the matrix Gamma is needed, because of  the
          symmetry.  Gamma should be positive definite.  Input of
          the matrix is in _r_o_w mode. That is,   Gamma  should  be
          given  as  Gamma[1][1],  Gamma[1][2],...,  Gamma[1][d],
          Gamma[2][2],..., Gamma[2][d],..., Gamma[d][d].

     mu   is a d-dimensional vector,  the  drift  vector  of  the
          reflected  Brownian motion. The reflection matrix R and
          the drift vector mu must satisfy a condition  in  order
          for   the  stationary  distribution  of  the  reflected
          Brownian motion to exist.

     R    is  a  d  times d  matrix, the reflection matrix of the
          reflected  Brownian  motion. The diagonal elements of R
          do not have to be one but should be positive. R  should
          be  non-singular and should be a completely-S matrix in
          order for the corresponding reflected  Brownian  motion
          to  exist.  R  and  mu must be such that the stationary
          distribution for the corresponding  reflected  Brownian
          motion exists.  The input of R is also in row mode.


EXAMPLE OF DATA FILE
     Only the numbers in the first two columns below are part  of
     the data file, the rest are descriptions.

      2             d          -dimension
      4             n          -maximum degree
      1    -0.2     Gamma      -covariance matrix
            2
     -0.4  -1.3     mu         -drift vector
      1     0       R          -reflection matrix
     -1     1


OUTPUT
     The output of bnet is self-explanatory. When  bnet  is  used
     together  with  a front end routine for performance analysis
     of a queueing network, the documentation of  the  front  end
     program  should  explain  to  you  how to interpret the mean
     position of the reflected Brownian motion  in  the  queueing



Sun Release 4.1      Last change: JUNE 1992                     2






BNET(1)                  USER COMMANDS                    BNET(1)



     network  context.  Actually,  in its internal logic the bnet
     program generates an approximation for the entire stationary
     density  function  of the reflected Brownian motion. If sum-
     mary statistics other than the mean of the distribution  are
     desired,  only a few more lines of code would be required to
     compute them.


AUTHOR
     Jim  Dai,  School  of  Mathematics  and   Industrial/Systems
     Engineering, Georgia Institute of Technology, Atlanta, Geor-
     gia 30332, USA (dai@isye.gatech.edu)

SEE ALSO
     _g_j_n(1) and _m_c_n(1) for converting queueing  network  data  to
     Brownian network data;

     J. G. Dai,  "Steady-state  analysis  of  reflected  Brownian
     motions:  characterization,  numerical  methods and queueing
     applications" (Ph.D. dissertation, Department  of  Mathemat-
     ics, Stanford University, June 1990);

     J. G. Dai and J. M. Harrison, "Steady-state analysis of  RBM
     in  a  rectangle:  numerical methods and a queueing applica-
     tion"  (Annals  of  Applied  Probability,  Vol.1,  pp.16-35,
     1991);

     J. G. Dai and J. M. Harrison, "Reflected Brownian motion  in
     an  orthant:  numerical  methods  for steady-state analysis"
     (Annals of Applied Probability, Vol.2, pp.65-86, 1992).

























Sun Release 4.1      Last change: JUNE 1992                     3



