#include "bnet.h"
#include <stdio.h>
#include <math.h>
double gmax;

#ifndef ANSI_C

FILE **option(argc, argv, print, mode, iterative, bnet_solver)
     int argc; 
     char *argv[];
     int *print;
     int *mode;
     int *iterative;
     int *bnet_solver;

#else


FILE **option(int argc, 
	      char *argv[],
	      int *print,
	      int *mode,
	      int *iterative,
	      int *bnet_solver
	      )
#endif
{
  FILE **fp = (FILE **) malloc((unsigned) 2*sizeof(FILE *));
  int c;

  while (--argc > 0 && (*++argv)[0] == '-')
    while ( c = *++argv[0])
      switch (c) {
      case 'v':
	(void) fprintf(stdout, " This is BNET 1.1, C version 1992;\n");
	(void) fprintf(stdout, " please contact dai@isye.gatech.edu for ");
	(void) fprintf(stdout, "possible newer version.\n\n");
	exit(0);
	break;
      case 'p':
	*print = TRUE;
	break;
      case 'b':
	*bnet_solver = TRUE;
	break;
      case 'h':
	(void)  fprintf(stderr, " Usage: bnet [-h] [-p] [-b] [-v]  ");
	(void)  fprintf(stderr, "[data_file [output_file]]\n");
	(void)  fprintf(stderr, " Options: \n");
	(void)  fprintf(stderr, "  -h print this help message \n");
	(void)  fprintf(stderr, "  -p print the input data \n");
	(void)  fprintf(stderr, "  -b use the bnet linear solver\n");
	(void)  fprintf(stderr, "  -v print the current version of bnet\n");
	exit (0);
	break;
	
/*
      case 'o':
	*mode = TRUE;
	break;
      case 'i':
	*iterative =TRUE;
	break;
*/
      default:
	(void) fprintf(stderr, " bnet: illegal option %c\n", c);
	argc = -1;
	break;
      }
  if ( argc < 0 || argc > 2) {
    (void)  fprintf(stderr, " Usage: bnet [-h] [-p] [-b] [-v]  ");
    (void)  fprintf(stderr, "[data_file [output_file]]\n");
    exit (0);
  }
  else if (argc == 0) {
    fp[0] = stdin;
    fp[1] = stdout;
  } 
  else if (argc == 1) {
    fp[0] = fopen(*argv, "r");
    fp[1] = stdout;
  }
  else if (argc == 2) {
    fp[0] = fopen(*argv++, "r");
    fp[1] = fopen(*argv, "w");  
  }
  return (fp);
}

#ifndef ANSI_C

MAT *get_covariance(d, input_fp)
     int d;
     FILE *input_fp;
#else

MAT *get_covariance(int d, FILE *input_fp)

#endif 
{
  MAT  *Gamma= get_mat(d, d);
  int i, j;

  for ( i =0; i<d; i++) for ( j =i; j< d; j++) 
    if (fscanf(input_fp, "%lf", &Gamma->me[i][j])!=1)
          Bneterror("input Gamma is wrong ");
  return (Gamma);
}

#ifndef ANSI_C


VEC *get_drift(d, input_fp)
     int d;
     FILE *input_fp;
#else
VEC *get_drift(int d, FILE *input_fp)
#endif 
{
  int i;
  VEC *mu = get_vec(d);

  for ( i =0; i<d; i++)
    if ( fscanf(input_fp,"%lf", &mu->ve[i])!=1)
      Bneterror("input mu is wrong ");  
  return (mu);
}

#ifndef ANSI_C

MAT *get_reflection(d, input_fp)
     int d;
     FILE *input_fp;

#else
MAT *get_reflection(int d, FILE * input_fp)
#endif 
{
  int i, j;
  MAT *R = get_mat(d, d);

  for ( i =0; i<d; i++) for ( j =0; j<d; j++)
    if ( fscanf(input_fp, "%lf", &R->me[i][j])!=1)
            Bneterror("input R is wrong ");
  return (R);
}

#ifndef ANSI_C
void _print_data(output_fp, Gamma, mu, R)
     FILE *output_fp;
     MAT  *Gamma;
     VEC  *mu;
     MAT  *R;

#else
void _print_data(FILE *output_fp,
		 MAT  *Gamma,
		 VEC  *mu,
		 MAT  *R
		 )
#endif 
{
  int i, j;
  int d = Gamma->n;
  
  (void) fprintf(output_fp, "\t dimension = %d\n", d);
  (void) fprintf(output_fp, "\t the covariance matrix Gamma =\n");
  for (i=0; i<d; i++) {
    for (j=0; j<i; j++) 
      (void) fprintf(output_fp, "\t %5.2f", Gamma->me[j][i]);
    for (j=i; j<d; j++) 
      (void) fprintf(output_fp, "\t %5.2f", Gamma->me[i][j]);
    (void) fprintf(output_fp, "\n");
  }
  (void) fprintf(output_fp, "\n");
  (void) fprintf(output_fp, "\t the drift vector mu =\n");
  for (i=0; i<d; i++) 
    (void) fprintf(output_fp, "\t %5.2f", mu->ve[i]);
  (void) fprintf(output_fp, "\n\n");
  (void) fprintf(output_fp, "\t the reflection matrix R =\n");
  for (i=0; i<d; i++) {
    for (j=0; j<d; j++) 
      (void) fprintf(output_fp, "\t %5.2f", R->me[i][j]);
    (void) fprintf(output_fp, "\n");
  }
  (void) fprintf(output_fp, "\n");
}


#ifndef ANSI_C
void print_original_data(output_fp, Gamma, mu, R, n)
     FILE *output_fp;
     MAT *Gamma;
     VEC *mu;
     MAT  *R;
     int   n;
#else
void print_original_data(FILE *output_fp,
			 MAT *Gamma,
			 VEC *mu,
			 MAT  *R,
			 int   n)
#endif 
{
  (void) fprintf(output_fp, 
		 "                   ORIGINAL INPUT DATA                  \n");
  (void) fprintf(output_fp, "\n");
  (void) _print_data(output_fp, Gamma, mu, R);
  (void) fprintf(output_fp, "\t maximum degree of polynomials used = %d\n", n);

}

#ifndef ANSI_C
void print_converted_data(output_fp, Gamma, mu, R, mygamma)
     FILE *output_fp;
     MAT *Gamma;
     VEC *mu;
     MAT *R;  
     VEC *mygamma;
#else
void print_converted_data(FILE *output_fp,
			  MAT *Gamma,
			  VEC *mu,
			  MAT *R,  
 			  VEC *mygamma)
#endif
{
  int i, j;
  int d= Gamma->n;

  (void) fprintf(output_fp, 
		 "\n                      CONVERTED DATA                  \n");
  (void) fprintf(output_fp, "\n");
  (void) _print_data(output_fp, Gamma, mu, R);
  (void) fprintf(output_fp, "\n");
  (void) fprintf(output_fp, "\t gamma_max = \n");
  (void) fprintf(output_fp, "\t %5.2f\n\n", gmax);
  (void) fprintf(output_fp, "\t the vector gamma =\n");
  for (i=0; i<d; i++) 
    (void) fprintf(output_fp, "\t %5.2f", mygamma->ve[i]);
  (void) fprintf(output_fp, "\n\n");
}


void Output(output_fp, rn, Gamma,  c, I, Ib, w, d, n)
     FILE *output_fp;
     poly *rn;
     MAT *Gamma;
     int **c, **I, **Ib, d, n;
     real **w;
{
  poly first_order_poly;
  void initpoly();
  real  *mean, inner();
  int l;

  initpoly(&first_order_poly, 1, c, d);
  mean = dvector(1, d);
  for (l=1; l<=d; l++) {
    first_order_poly.itr[l+1] = 1.0;
    /* scale back, see A.1 in Dai's disertation */
    mean[l] = (real)sqrt((double)Gamma->me[l-1][l-1])
      /gmax * inner(rn, n-1, &first_order_poly, 1, c, I, Ib, w, d);
    first_order_poly.itr[l+1] = 0.0;
  }
/*
  (void) fprintf(output_fp, "\n Here is the mean position of the reflected Brownian motion.");
  (void) fprintf(output_fp, "\n Please check your manual to interpret this result under queueing ");
  (void) fprintf(output_fp, "\n   network context.\n\n"); */

  for (l=1; l<=d; l++) 
   (void)  fprintf(output_fp, " mean [%2d] = %10.4f \n", l, mean[l]);
}



/* scaling(output_fp, Gamma, mu, R, mygamma);  */
#ifndef ANSI_C
void scaling(output_fp, Gamma, mu, R, mygamma)
     FILE *output_fp;
     MAT *Gamma;
     VEC *mu;
     MAT *R;
     VEC *mygamma;
#else
void scaling(FILE *output_fp,
	     MAT *Gamma,
	     VEC *mu,
	     MAT *R,
	     VEC *mygamma)
#endif 

{
  int i, j;
  int d = Gamma->n;
  double  tem;
  MAT *Rcpy = get_mat(d, d);
  VEC *mucpy = get_vec(d);
  PERM *pivt=get_perm(d);


  for ( i = 0; i<d; i++)
    mu->ve[i] = mu->ve[i] / sqrt( Gamma->me[i][i]);
  for ( j =0; j<d; j++)  {
    tem = R->me[j][j];
    if (tem == 0.0 ) Bneterror("R[i][i] == 0");
    else
      for ( i =0;i<d; i++) 
	R->me[i][j] = R->me[i][j]*  sqrt(Gamma->me[j][j])
	  /( tem  * sqrt(Gamma->me[i][i]));
  }
  cp_vec(mu, mucpy);
  cp_mat(R, Rcpy);
  LUfactor(Rcpy, pivt);
  LUsolve(Rcpy, pivt, mucpy, mygamma);
  for (i=0; i<d; i++)  mygamma->ve[i] = -mygamma->ve[i];
  gmax = fabs(mygamma->ve[0]);
  for (i=1; i<d; i++) if (fabs(mygamma->ve[i]) >gmax)
    gmax = fabs(mygamma->ve[i]);
  if ((gmax) == 0.0)
    Bneterror("gamma_max is zero, there is no stationary density");
  for (i=0; i<d; i++) {
    mu->ve[i] /= (gmax);
    mygamma->ve[i] /= gmax;
  }
  for ( i =0; i<d; i++) for ( j =i+1; j<d; j++) 
    Gamma->me[i][j] = Gamma->me[i][j] / (sqrt(Gamma->me[i][i])
				 * sqrt(Gamma->me[j][j]));
  freevec(mucpy);
  freemat(Rcpy);
}
