#ifndef BNET_H
#define BNET_H 1

#include <math.h>
/* This is "bnet.h" file */

      /* if there is no system include file "/usr/include/malloc.h"
	 delete the first line in this file and add the following line

	 extern char *malloc()  or
	 extern void *malloc()
	 */
/* #include <stdlib.h> */

      /* on some system, the next line should be changed into
	 extern void  *callo();
	 use "lint *.c" to determine  which version your system is using.
	 */
/*  extern  char *calloc(); */

      /* on some system the next line should be 
	 extern void free();
	 use "lint *.c" to determine  which version your system is using.
	 */

/* extern int  free(); */

      /* on some system the next line should be
	 extern void exit();
	 use "lint *.c" to determine which version your system is using.
	 */
/* extern  int  exit(); */

#ifndef TRUE 
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#ifndef True 
#define True 1
#endif
#ifndef False
#define False 0
#endif

     /* change following line if you want everything to be double (precision)
	instead of float (single precision)
	*/
/* typedef float real; */
 typedef double real; 

extern double gmax;

typedef struct {
  real *itr;
  real **bd;
} poly;

     /* bnet utility functions */                              
extern float  *vector();       /* allocate memory space to hold a vector */
extern int    *ivector();      /* allocate memory space to hold a vector */
extern real   *dvector();      /* allocate memory space to hold a vector */
extern real   *cvector();      /* allocate memory space to hold a vector */
extern float  **matrix();      /* allocate memory space to hold a matrix */
extern int    **imatrix();     /* allocate memory space to hold a matrix */
extern real   **dmatrix();     /* allocate memory space to hold a matrix */
extern real   **cmatrix();     /* allocate memory space to hold a matrix */
extern void   free_ivector();  /* free spaces allocated by ivector()     */
extern void   free_dvector();  /* free spaces allocated by dvector()     */
extern void   free_imatrix();  /* free spaces allocated by imatrix()     */
extern void   free_dmatrix();  /* free spaces allocated by dmatrix()     */
extern void   Bneterror();     /* bnet error handling function           */


  
extern  void     print_original_data(), print_converted_data(), scaling();
extern  int      **ComputeC(), **ComputeIndex();
extern  double   **ComputeWeight();
extern  void     Basis(),   orthogonalize(), Density1(), Density2(), Output();
extern  void     coefficient();

#ifndef ANSI_C
#include <stdio.h>
extern  int      get_dimension();
extern  int      get_degree();
extern  FILE   **option();

#include "matrix.h"

extern MAT* get_covariance();
extern MAT* get_reflection();
extern VEC* get_drift();
extern void scaling();
#else
#include <stdio.h>

extern  int      get_dimension(FILE *);
extern  int      get_degree(FILE *);
extern FILE **option(int argc, char *argv[], 
		     int *print, int *mode, int *iterative, int *imsl);
#include "matrix.h"

extern MAT* get_covariance(int d, FILE *);
extern MAT* get_reflection(int d, FILE *);
extern VEC* get_drift(int d, FILE *);
extern void scaling(FILE *output_fp,
	     MAT *Gamma,
	     VEC *mu,
	     MAT *R,
	     VEC *mygamma);
#endif 
#endif
