#include <stdio.h>
#include "bnet.h"
#include "matrix.h"

#ifndef ANSI_C
int main(argc, argv)
     int argc;
     char *argv[];
#else
int main(int argc, char *argv[])
#endif
{
  int     print     = FALSE; /* = TRUE to print detailed data */
  int     old_fash  = FALSE; /* = TRUE to use orthogonalization */
  int     bnet_solver = FALSE; /* allows to use different linear solvers*/
  int     iterative = FALSE;  /* use iterative improvements in solvers */  
  FILE **fp = option(argc, argv, &print, &old_fash, &iterative, &bnet_solver);
  FILE *input_fp  = fp[0]; 
  FILE *output_fp = fp[1]; 
  int   d      = get_dimension(input_fp);
  int   n      = get_degree(input_fp);
  MAT  *Gamma  = get_covariance(d, input_fp);
  VEC  *mu     = get_drift(d, input_fp);
  MAT  *R      = get_reflection(d, input_fp);
  int   **c    = ComputeC(d, n);
  int   **I    = ComputeIndex(c, d,  n);
  int   **Ib   = ComputeIndex(c, d-1, n);
  VEC    *mygamma = get_vec(d);
  double   **w;  
  poly     *Af, rn;
  double **_A;
  S_MAT *A;
  VEC *b;
  int i, j;
  
  if (print == TRUE)
    print_original_data(output_fp, Gamma, mu, R, n);
  scaling(output_fp, Gamma, mu, R, mygamma); 

  if (print == TRUE) 
    print_converted_data(output_fp, Gamma, mu, R, mygamma);
  w = ComputeWeight(mygamma->ve-1, d, n); /* w[l][i] = i!/(2 gamma_l)^{i+1} */
  Af = (poly *) malloc((unsigned) (c[d][n]-1) * sizeof(poly));
  if (!Af) Bneterror("Allocation Failure for Af in basis()");
  Af -=2;
  Basis(Af,  Gamma, mu, R, c, I, n);
  A = get_s_mat(c[d][n]-1);
  b = get_vec(c[d][n]-1);
  coefficient(Af, A, b, c, I, Ib, w, n, Gamma, mu, R);
  if (bnet_solver == FALSE) {
    fprintf(stderr," Invoking BNET m linear solver ...\n");
    S_CHfactor(A);
    S_CHsolve(A, b, b);
/*    frees_mat(A); */
  }
  else {
    _A = dmatrix(1, c[d][n]-1, 1, c[d][n]-1);
    for (i=1; i<=c[d][n]-1; i++) {
      for (j=1; j<=i; j++) 
	_A[i][j] = A->me[i-1][j-1] ; /* lower triangular part only*/
    }
/*    frees_mat(A); */
    fprintf(stderr," Invoking BNET b linear solver ...\n");
    gaxpy_cholesky(_A, c[d][n]-1);
    fwsub(_A, b->ve-1, c[d][n]-1);
    bksub(_A, b->ve-1, c[d][n]-1);
    free_dmatrix(_A, 1, d, 1, d);
  }
  Density1(Af, b,  &rn, c, I, Ib, w, d, n);
  freevec(b);
  Output(output_fp,  &rn, Gamma,  c, I, Ib, w, d, n); 
  return 0;
}

#ifndef ANSI_C
void  Basis(Af, Gamma, mu, R,  c, I, n)
     poly *Af;
     int **c, **I, n;
     MAT  *Gamma;
     VEC  *mu;
     MAT  *R;
#else
void  Basis(poly    *Af, 
	    MAT    *Gamma,
	    VEC    *mu,
	    MAT    *R,
	    int    **c,
	    int    **I,
	    int     n
	    )
#endif
{
   int i, j, l, k, N;
   int d = Gamma->n;

   int *II, *IIb;
   void initpoly();
   long Index();

   II = ivector(0, d);
   IIb= ivector(0, d-1);
   N = c[d][n];
   for (i=2; i<=N; i++) {
     initpoly(Af+i, I[i][0]-1, c, d);
     /* starts filling interior  polynomial */
     for (j=0; j<=d; j++) II[j] = I[i][j];
     for (j=1; j<=d; j++) {
       if (II[j]>=1) {
	 II[0]--; II[j]--;
	 Af[i].itr[Index(d, II,c)]=I[i][j]*mu->ve[j-1];
	 if (II[j]>=1) {
	   II[0]--; II[j]--;
	   Af[i].itr[Index(d,II, c)] = I[i][j]*(I[i][j]-1)/2; 
	   II[0]++; II[j]++;
	 }
	 II[0]++; II[j]++;
       }
     }
     for (j=1; j<=d; j++) for (l=j+1; l<=d; l++)
       if (II[j] >=1 && II[l] >=1) {
	 II[0] -= 2; II[j]--; II[l]--;
	 Af[i].itr[Index(d, II, c)] = I[i][j] * I[i][l] * Gamma->me[j-1][l-1];
	 II[0] += 2; II[j]++; II[l]++;
       }
     /* starts filling  boundary polynomials */
     for (j=1; j<=d; j++) {
       if (II[j] == 1) {
	 IIb[0] = II[0] - 1;
	 for (l=1; l<j; l++) IIb[l] = II[l];
	 for (l=j; l<d; l++) IIb[l] = II[l+1];
	 Af[i].bd[j][Index(d-1, IIb,c)] = R->me[j-1][j-1];
       }
       if (II[j] == 0) {
	 for (l=1; l<=d; l++) if (II[l] >= 1) {
	   II[l]--;
	   for (k=0; k<j; k++) IIb[k] = II[k];
	   for (k=j; k<d; k++) IIb[k] = II[k+1];
	   IIb[0]--; II[l]++;
	   Af[i].bd[j][Index(d-1, IIb,c)] = II[l] * R->me[l-1][j-1];
	 }
       }
     }
   }
   free((char *)II);
   free((char *)IIb);
 }

 void initpoly(f, k, c, d)
      poly *f;
      int k;
      int **c, d;
 {

   f->itr = cvector(1, c[d][k]);
   f->bd = cmatrix(1, d, 1, c[d-1][k]);
 }


void Density1(Af, b, rn, c, I, Ib, w, d, n)
     poly *Af, *rn;
     VEC *b;
     int  **c, **I, **Ib;
     real **w;
     int d, n;
{
  int    i, j, l,  k, N;
  poly   phi_0;
  real tmp;
  extern real inner();
  extern void   half_linear();
  extern void   initpoly();


  /* give space and initialize */
  initpoly(rn, n-1, c, d);
  initpoly(&phi_0, 0, c, d); 
  phi_0.itr[1] = 1.0;     /*phi_0 = (1; 0, 0, ..., 0) */
  rn->itr[1] = 1.0;        /*p = psi_1=(1; 1, 1, ..., 1) */
  for (l=1; l<=d; l++) {
    rn->bd[l][1] = 1.0;
  }                       /* set phi_0 = phi_1 */
                          /* end of initialization */
  N = c[d][n];
  for ( k=2; k<=N; k++) {
    half_linear( rn, n-1, -b->ve[k-2], Af+k, I[k][0]-1, rn, c, d);
  }
  /* normalize */
  tmp = inner( &phi_0, 0, rn, n-1, c, I, Ib, w, d);
  if ( tmp==0.0) Bneterror(" can not be noramlized into a density");
  tmp = 1/tmp;
  N = c[d][n-1];
  for ( i=1; i<=N; i++)
    rn->itr[i] *= tmp;
  N = c[d-1][n-1];
  for ( j =1; j<=d; j++)
    for ( i=1; i<=N; i++)
      rn->bd[j][i] *= tmp;
}

void Density2(Af, rn, c, I, Ib, w, d, n)
     poly *Af, *rn;
     int  **c, **I, **Ib;
     real **w;
     int d, n;
{
  int    i, j, l,  k, N;
  poly   phi_0;
  real tmp;
  extern real inner();
  extern void   half_linear();
  extern void   initpoly();


  /* give space and initialize */
  initpoly(rn, n-1, c, d);
  initpoly(&phi_0, 0, c, d); 
  phi_0.itr[1] = 1.0;     /*phi_0 = (1; 0, 0, ..., 0) */
  rn->itr[1] = 1.0;        /*p = psi_1=(1; 1, 1, ..., 1) */
  for (l=1; l<=d; l++) {
    rn->bd[l][1] = 1.0;
    phi_0.bd[l][1] = 1.0;
  }                       /* set phi_0 = phi_1 */
                          /* end of initialization */
  N = c[d][n];
  for ( k=2; k<=N; k++) {
    tmp = inner(Af+k, I[k][0]-1, Af+k, I[k][0]-1, c, I, Ib, w, d);
    if ( tmp ==0.0) Bneterror(" Can not be normalized when finding density");
    tmp = - inner(&phi_0,  0 , Af+k, I[k][0]-1, c , I, Ib, w, d)/tmp;
    half_linear( rn, n-1, tmp, Af+k, I[k][0]-1, rn, c, d);
  }
  /* normalize */
  for (l=1; l<=d; l++)    /* set phi_0 back to phi_0 */
    phi_0.bd[l][1] = 0.0;
  tmp = inner( &phi_0, 0, rn, n-1, c, I, Ib, w, d);
  if ( tmp==0.0) Bneterror(" can not be noramlized into a density");
  tmp = 1/tmp;
  N = c[d][n-1];
  for ( i=1; i<=N; i++)
    rn->itr[i] *= tmp;
  N = c[d-1][n-1];
  for ( j =1; j<=d; j++)
    for ( i=1; i<=N; i++)
      rn->bd[j][i] *= tmp;
}

void orthogonalize(Af, c, I, Ib, w, d, n)
     poly *Af;
     int **c, **I, **Ib;
     real **w;
     int d, n;
{
  int t, i, N;
  real tmp;
  extern real inner();
  extern void half_linear();
  extern void Bneterror();
  
  N = c[d][n];
  for ( t=3; t<=N; t++) for ( i =2; i<t; i++) {
    tmp = inner(Af+i, I[i][0]-1, Af+i, I[i][0]-1, c, I, Ib, w, d);
    if (tmp ==0.0) Bneterror(" Can not orthogonalize, divisor zero ");
    tmp = -inner(Af+t, I[t][0]-1, Af+i, I[i][0]-1, c, I, Ib, w, d)/tmp;
    half_linear( Af+t, I[t][0]-1, tmp, Af+i, I[i][0]-1, Af+t, c, d);
  }
}



void coefficient(Af, A, b, c, I, Ib, w, n, Gamma, mu, R)
     poly *Af;
     S_MAT *A;
     VEC *b;
     int **c, **I, **Ib;
     real **w;
     int  n;
     MAT *Gamma;
     VEC *mu;
     MAT *R;
{
  int t, i, N, *K;
  int d = Gamma->n;
  extern real inner(), inner_1(), inner_2();
  extern int *ivector();
  poly psi_1;
  void initpoly();

  N = c[d][n];
  
  K = ivector(1, d);
  for ( t=2; t<=N; t++) 
    for ( i=2; i<=t; i++) 
      A->me[t-2][i-2] = inner_2( I[t],I[i], K,  w, Gamma, mu, R,  d); 
  
  initpoly(&psi_1, 0, c, d);
  psi_1.itr[1]= 1.0;
  for (i=1; i<=d; i++)
    psi_1.bd[i][1] = 1.0;
  for (t=2; t<=N; t++)
    b->ve[t-2] = inner(Af+t, I[t][0]-1, &psi_1, 0, c, I, Ib, w, d);
}


real inner(f, t,  g, m, c, I, Ib, w, d)  
     poly *f, *g;
     int t, m;
     int **c, **I, **Ib;
     real **w;
     int d;

{
  int i, j, l, k, tt, mm=c[d][m];
  real tmp=0.0;
  real prod;
  real *fp, *gp; 

  for (i=c[d][t], fp = f->itr + i; i; i--,fp--)
    for (j=mm, gp =  g->itr + j; j; j--, gp--) {
      for (l=d, prod = 1.0; l; l--)
	prod *= w[l][I[i][l]+I[j][l]];
      tmp += (*fp) * (*gp) * prod;
    }

  tt =  c[d-1][t];
  mm =  c[d-1][m];
  for (k=d; k; k--) {
    for (i=tt, fp = f->bd[k] + i; i; i--, fp--) {
      for (j=mm, gp = g->bd[k] + j; j; j--, gp--) {
	prod = 1.0;
	for (l =k-1; l;l--)
	  prod *= w[l][Ib[i][l]+Ib[j][l]];
	for (l =k; l<d ;l++)
	  prod *= w[l+1][Ib[i][l]+Ib[j][l]];
	tmp += 0.5 * *fp * *gp * prod;
      }
    }
  }
  return (tmp);
}


void half_linear(f, t,  a,  g, m, h, c, d)  
     /* h = f + a * g, deg(f)=t, deg(g) =m  m<= t */
     int t, m;
     poly *f, *g, *h;
     real a;
     int **c;
     int d;
{
  int i=c[d][m], j, mm=c[d-1][m];
  extern void Bneterror();
  real *hp = h->itr + i, *fp = f->itr + i, *gp = g->itr + i;
  
  if ( t<m) Bneterror(" the degree of first poly should be bigger ");
  while (i--) *hp-- = *fp-- + a * (*gp--);

  for ( j =d; j; j--) {
    i = mm;
    hp = h->bd[j] + i;
    fp = f->bd[j] + i;
    gp = g->bd[j] + i;
    while (i--) *hp-- = *fp-- + a * (*gp--);
  }
}  


real  inner_2(I, J, K,  w, Gamma, mu, R, d)
     int *I, *J, *K, d;
     real **w;
     MAT *Gamma;
     VEC *mu;
     MAT *R;
{
  int i, l, j, k, m;
  real sum = 0.0, prod;

  for (m =d; m; m--)   K[m] = I[m]+J[m];  
  for (i=d; i; i--)  for (j=d; j; j--) 
    if (I[i] >= 1 && J[j] >= 1) {
  
      K[i]--;  K[j]--;
      prod = 1.0;  for (m=d; m; m--)  prod *=w[m][K[m]];
      sum += I[i] * mu->ve[i-1] * J[j] * mu->ve[j-1] * prod;
      K[i]++; K[j]++; /* do not destroy K, K will be used later */
      
      if (J[j] >= 2) {
	K[i]--;  K[j] -= 2;
	prod = 1.0;  for (m=d; m; m--)  prod *=w[m][K[m]];
	    sum += I[i] * mu->ve[i-1] * 0.5 * J[j] * (J[j]- 1) * prod;
	K[i]++;  K[j] += 2;
      }

      for (k=j+1; k<=d; k++)
	if (J[k] >= 1) {
	  K[i]--;  K[j]--; K[k]--;
	  prod = 1.0;  for (m=d; m; m--)  prod *=w[m][K[m]];
	  sum += I[i] * mu->ve[i-1] * J[j] * J[k] * Gamma->me[j-1][k-1] * prod;
	  K[i]++;  K[j]++; K[k]++;
	}
	
      
      if (I[i] >= 2) {
	K[i] -= 2;  K[j]--;
	prod = 1.0;  for (m=d; m; m--)  prod *=w[m][K[m]];
	sum += 0.5 * I[i] * (I[i] - 1) * J[j] * mu->ve[j-1] * prod;
	K[i] += 2;  K[j]++;

	if (J[j] >= 2) {
	  K[i] -= 2;  K[j] -= 2;
	  prod = 1.0;  for (m=d; m; m--)  prod *=w[m][K[m]];
	  sum += 0.5 * I[i] * (I[i]-1) * 0.5 * J[j] * (J[j]- 1) * prod;
	  K[i] += 2;  K[j] += 2;
	}


	for (k=j+1; k<=d; k++)
	  if (J[k] >= 1) {
	    K[i] -= 2;  K[j]--; K[k]--;
	    prod = 1.0;  for (m=d; m; m--)  prod *=w[m][K[m]];
	    sum += 0.5 * I[i] * (I[i]-1) * J[j] * J[k] * Gamma->me[j-1][k-1] * prod;
	    K[i] += 2;  K[j]++; K[k]++;
	  }
      }

      for (l=i+1; l<=d; l++) if (I[l] >= 1) {
	K[i]--; K[l]--; K[j]--;
	prod = 1.0; for (m=d; m; m--)  prod *=w[m][K[m]];
	sum += I[i] * I[l] * Gamma->me[i-1][l-1] * J[j] * mu->ve[j-1] * prod;
	K[i]++; K[l]++; K[j]++;

	if (J[j] >= 2) {
	  K[i]--; K[l]--; K[j] -= 2;
	  prod = 1.0; for (m=d; m; m--)  prod *=w[m][K[m]];
	  sum += I[i] * I[l] * Gamma->me[i-1][l-1] * 0.5 * J[j] * (J[j]-1) * prod;
	  K[i]++; K[l]++; K[j] += 2;
	}

	for (k=j+1; k<=d; k++) if ( J[k] >= 1) {
	  K[i]--; K[l]--; K[j]--; K[k]--;
	  prod = 1.0; for (m=d; m; m--)  prod *=w[m][K[m]];
	  sum += I[i] * I[l] * Gamma->me[i-1][l-1] * J[j] * J[k] * Gamma->me[j-1][k-1] * prod;
	  K[i]++; K[l]++; K[j]++; K[k]++;
	}
      }
    }
  /* boundary part */
  for (l=d; l; l--) { 
    if (I[l] == 1) {
      if (J[l] == 1) {
	for (m=d, prod=1.0; m; m--) prod *= w[m][K[m]];
	prod /= w[l][K[l]];
	sum += 0.5 * R->me[l-1][l-1] * R->me[l-1][l-1] * prod;  
      }
    
      else if (J[l] == 0)
	for (j=d; j; j--) 
	  if (J[j] >= 1) {
	    K[j]--;
	    for (m=d, prod=1.0; m; m--) prod *= w[m][K[m]];
	    prod /= w[l][K[l]];
	    sum += 0.5 *  R->me[l-1][l-1] *J[j] * R->me[j-1][l-1] * prod;  
	    K[j]++;
	  }
    }
    else if (I[l] == 0 ) {
      if (J[l] == 1) {
	for (i=d; i; i--) 
	  if (I[i] >= 1) {
	    K[i]--;
	    for (m=d, prod=1.0; m; m--) prod *= w[m][K[m]];
	    prod /= w[l][K[l]];	  
	    sum += 0.5 * I[i] * R->me[i-1][l-1] * R->me[l-1][l-1] * prod;  
	    K[i]++;
	  }
      }
      
      else if ( J[l] == 0) {
	for (i=d; i; i--) 
	  if (I[i] >= 1)
	    for (j=d; j; j--)
	      if ( J[j] >= 1) {
		K[i]--; K[j]--;
		for (m=d, prod=1.0; m; m--) prod *= w[m][K[m]];
		prod /= w[l][K[l]];	  
		sum += 0.5 * I[i] * R->me[i-1][l-1] *J[j] * R->me[j-1][l-1] * prod;  
		K[i]++; K[j]++;
	      }
      }
    }
  }
  return (sum);
}

real  inner_1(I, J, K,  w, Gamma, mu, R, d)
     int *I, *J, *K, d;
     real **w, **Gamma, *mu, **R;
{
  int i, l, j, k, m;
  real sum = 0.0, prod = 1.0;

  for (m =d; m; m--) {
    K[m] = I[m]+J[m];
    prod *=w[m][K[m]];
  }  
  
  for (i=d; i; i--)  for (j=d; j; j--) 
    if (I[i] >= 1 && J[j] >= 1) {
 
      /*  K[i]--;  K[j]--; */
      if (i==j)
	sum += I[i] * mu[i] * J[j] * mu[j] * prod 
	  * w[i][K[i]-2] / (w[i][K[i]]);
      else
	sum += I[i] * mu[i] * J[j] * mu[j] * prod 
	  * w[i][K[i]-1] * w[j][K[j]-1] / (w[i][K[i]]* w[j][K[j]]);
      
      if (J[j] >= 2) { 	/* K[i]--;  K[j] -= 2; */
	if (i==j)
	  sum += I[i] * mu[i] * 0.5 * J[j] * (J[j]- 1) * prod
	    * w[i][K[i]-3] / (w[i][K[i]]);
	else
      	  sum += I[i] * mu[i] * 0.5 * J[j] * (J[j]- 1) * prod
	    * w[i][K[i]-1] * w[j][K[j]-2] / (w[i][K[i]]* w[j][K[j]]);
      }

      for (k=j+1; k<=d; k++)
	if (J[k] >= 1) {  /*  K[i]--;  K[j]--; K[k]--; */
	  if ( i==j) /* this case !=i */
	    sum += I[i] * mu[i] * J[j] * J[k] * Gamma[j][k] * prod
	      * w[i][K[i]-2] * w[k][K[k]-1] / 
		(w[i][K[i]]* w[k][K[k]]);
	  else if (i == k) 
	    sum += I[i] * mu[i] * J[j] * J[k] * Gamma[j][k] * prod
	      * w[i][K[i]-2] * w[j][K[j]-1]  / 
		(w[i][K[i]]* w[j][K[j]]);
	  else 
	    sum += I[i] * mu[i] * J[j] * J[k] * Gamma[j][k] * prod
	      * w[i][K[i]-1] * w[j][K[j]-1] * w[k][K[k]-1] / 
		(w[i][K[i]]* w[j][K[j]] * w[k][K[k]]);
	}

      if (I[i] >= 2) {	/* K[i] -= 2;  K[j]--; */
	if (i==j)
	  sum += 0.5 * I[i] * (I[i] - 1) * J[j] * mu[j] * prod
	    * w[i][K[i]-3] / (w[i][K[i]]);
	else 
	  sum += 0.5 * I[i] * (I[i] - 1) * J[j] * mu[j] * prod
	    * w[i][K[i]-2] * w[j][K[j]-1] / (w[i][K[i]]* w[j][K[j]]);

	if (J[j] >= 2){   /*  K[i] -= 2;  K[j] -= 2; */
	  if (i==j)
	    sum += 0.5 * I[i] * (I[i]-1) * 0.5 * J[j] * (J[j]- 1) * prod
	      * w[i][K[i]-4] / (w[i][K[i]]);
	  else 
	    sum += 0.5 * I[i] * (I[i]-1) * 0.5 * J[j] * (J[j]- 1) * prod
	      * w[i][K[i]-2] * w[j][K[j]-2] / (w[i][K[i]]* w[j][K[j]]);
	}
	
	for (k=j+1; k<=d; k++)
	  if (J[k] >= 1) { /*   K[i] -= 2;  K[j]--; K[k]--; */
	    if (i==j)
	      sum += 0.5 * I[i] * (I[i]-1) * J[j] * J[k] * Gamma[j][k] * prod
		* w[i][K[i]-3] * w[k][K[k]-1] / 
		  (w[i][K[i]]* w[k][K[k]]);
	    else if (i==k)
	      sum += 0.5 * I[i] * (I[i]-1) * J[j] * J[k] * Gamma[j][k] * prod
		* w[i][K[i]-3] * w[j][K[j]-1] / 
		  (w[i][K[i]]* w[j][K[j]]);
	    else
	      sum += 0.5 * I[i] * (I[i]-1) * J[j] * J[k] * Gamma[j][k] * prod
		* w[i][K[i]-2] * w[j][K[j]-1] * w[k][K[k]-1] / 
		  (w[i][K[i]]* w[j][K[j]] * w[k][K[k]]);
	  }
      }

      for (l=i+1; l<=d; l++) if (I[l] >= 1) {/*	K[i]--; K[l]--; K[j]--;*/
	if (j==i)
	  sum += I[i] * I[l] * Gamma[i][l] * J[j] * mu[j] * prod
	    * w[i][K[i]-2] * w[l][K[l]-1] / 
	      (w[i][K[i]]* w[l][K[l]]);
	else if (j == l)
	  sum += I[i] * I[l] * Gamma[i][l] * J[j] * mu[j] * prod
	    * w[i][K[i]-1] * w[j][K[j]-2] / 
	      (w[i][K[i]]* w[j][K[j]]);
	else
	  sum += I[i] * I[l] * Gamma[i][l] * J[j] * mu[j] * prod
	    * w[i][K[i]-1] * w[j][K[j]-1] * w[l][K[l]-1] / 
	      (w[i][K[i]]* w[j][K[j]] * w[l][K[l]]);

	if (J[j] >= 2) { /* K[i]--; K[l]--; K[j] -= 2; */
	  if (j == i)
	    sum += I[i] * I[l] * Gamma[i][l] * 0.5 * J[j] * (J[j]-1) * prod
	      * w[i][K[i]-3] * w[l][K[l]-1] / 
		(w[i][K[i]]* w[l][K[l]]);
	  else if (j == l)
	    sum += I[i] * I[l] * Gamma[i][l] * 0.5 * J[j] * (J[j]-1) * prod
	      * w[i][K[i]-1] * w[j][K[j]-3] / 
		(w[i][K[i]]* w[j][K[j]]);
	  else 
	    sum += I[i] * I[l] * Gamma[i][l] * 0.5 * J[j] * (J[j]-1) * prod
	      * w[i][K[i]-1] * w[j][K[j]-2] * w[l][K[l]-1] / 
		(w[i][K[i]]* w[j][K[j]] * w[l][K[l]]);
	}

	for (k=j+1; k<=d; k++)
	  if ( J[k] >= 1) { /* K[i]--; K[l]--; K[j]--; K[k]--; */
	    if (i==j) {
	      if (l==k)
		sum += I[i] * I[l] * Gamma[i][l] * J[j] * J[k] * Gamma[j][k]
		  * prod  * w[i][K[i]-2] * w[l][K[l]-2] /
		      (w[i][K[i]] * w[l][K[l]]);
	      else 
		sum += I[i] * I[l] * Gamma[i][l] * J[j] * J[k] * Gamma[j][k]
		  * prod  * w[i][K[i]-2] * w[l][K[l]-1] * 
		    w[k][K[k]-1] / 
		      (w[i][K[i]] * w[l][K[l]] * w[k][K[k]]);
	    }
	    else {
	      if (i==k ){
		if(j==l)
		  sum += I[i] * I[l] * Gamma[i][l] * J[j] * J[k] * Gamma[j][k]
		    * prod  * w[i][K[i]-2] * w[j][K[j]-2] / 
			(w[i][K[i]]* w[j][K[j]]);
		else  /* i==k , j!=l */
		  sum += I[i] * I[l] * Gamma[i][l] * J[j] * J[k] * Gamma[j][k]
		    * prod  * w[i][K[i]-2] * w[j][K[j]-1] * w[l][K[l]-1]/ 
			(w[i][K[i]]* w[j][K[j]] * w[l][K[l]] );
	      }
	      else if (j==l)/*  i!=j, i!=k j == l */
		sum += I[i] * I[l] * Gamma[i][l] * J[j] * J[k] * Gamma[j][k]
		  * prod  * w[i][K[i]-1] * w[j][K[j]-2] *  
		    w[k][K[k]-1] / 
		      (w[i][K[i]]* w[j][K[j]]  * w[k][K[k]]);
	      else
		sum += I[i] * I[l] * Gamma[i][l] * J[j] * J[k] * Gamma[j][k]
		  * prod  * w[i][K[i]-1] * w[j][K[j]-1] * w[l][K[l]-1] * 
		    w[k][K[k]-1] / 
		      (w[i][K[i]]* w[j][K[j]] * w[l][K[l]] * w[k][K[k]]);
	    }
	  }
      }
    }
  /* boundary part */
  for (l=d; l; l--) { 
    if (I[l] == 1) {
      if (J[l] == 1) 
    	sum += 0.5 * R[l][l] * R[l][l] * prod / w[l][K[l]];
      
      else if (J[l] == 0)
	for (j=d; j; j--) 
	  if (J[j] >= 1)  /*   K[j]--; */
	    sum += 0.5 *  R[l][l] *J[j] * R[j][l] * prod * w[j][K[j]-1]
	      / (w[l][K[l]] * w[j][K[j]]);  
    }
    else if (I[l] == 0 ) {
      if (J[l] == 1) {
	for (i=d; i; i--) 
	  if (I[i] >= 1) /*     K[i]--; */
	    sum += 0.5 * I[i] * R[i][l] * R[l][l] * prod * w[i][K[i]-1]
	      /(w[i][K[i]] * w[l][K[l]]);  
      }
      
      else if ( J[l] == 0) {
	for (i=d; i; i--) 
	  if (I[i] >= 1)
	    for (j=d; j; j--)
	      if ( J[j] >= 1) { /* K[i]--; K[j]--; */
		if (i==j)
		  sum += 0.5 * I[i] * R[i][l] *J[j] * R[j][l] * prod
		    * w[i][K[i]-2]
		      /(w[i][K[i]] * w[l][K[l]]);  
		else
		  sum += 0.5 * I[i] * R[i][l] *J[j] * R[j][l] * prod
		    * w[i][K[i]-1] * w[j][K[j]-1] 
		      /(w[i][K[i]] * w[j][K[j]] * w[l][K[l]]);  
	      }
      }
    }
  }
  return (sum);
}

#ifndef ANSI_C
int get_dimension(input_fp)
     FILE * input_fp;
#else
int get_dimension(FILE * input_fp)
#endif 
{
  int d;
  if( fscanf(input_fp,"%d", &d) != 1)
    error(EF_EXIT,"d should be a positive integer");
  return d;
}

#ifndef ANSI_C
int get_degree(input_fp)
     FILE * input_fp;
#else
int get_degree(FILE * input_fp)
#endif 

{
  int n;
  
  if( fscanf(input_fp,"%d", &n) != 1)
        error(EF_EXIT,"n should be a positive integer");
  return n;
}

