%% clear all the enviroment variables
close all
clear all

%% Parameter setting to generate pre-change and post-change time series

d = 1; % the dimension of the parameter space
% in the normal mean detection case, it is the dimension of mean vector
% d can also be seen as the number of sensors in the context of
% multi-sensor detection
Pre_beta = 1; % the beta before the change-point
w = 100; % w is the window-size used in the procedures

%% Calculate the threshold b in order to make ARL be Gamma
Gamma = 10000; % Gamma is the allowable lower bound for ARL

T = 500; % the length of pre-change sequence
%%

%b_CUSUM = Threshold_Gamma('CUSUM', T, d, Pre_beta, Gamma, w);
% b_GLR = Threshold_normal_mean('GLR', T, d, Pre_mean, Gamma, w);
% b_SRRS = Threshold_normal_mean('SRRS', T, d, Pre_mean, Gamma, w);
% b_ACM = Threshold_normal_mean('ACM', T, d, Pre_mean, Gamma, w); 
% b_WLCUSUM = Threshold_normal_mean('WLCUSUM', T, d, Pre_mean, Gamma, w);
% b_WLGLR_V = Threshold_Gamma('WLGLR_V', T, d, Pre_beta, Gamma, w);
%b_WLSRRS = Threshold_Gamma('WLSRRS', T, d, Pre_beta, Gamma, w);
%b_WLACM = Threshold_Gamma('WLACM', T, d, Pre_beta, Gamma, w); 
%b_WLACM_L1 = Threshold_normal_mean('WLACM_L1', T, d, Pre_mean, Gamma, w); 
%b_WLSRRS_L1 = Threshold_normal_mean('WLSRRS_L1', T, d, Pre_mean, Gamma, w); 
%b_LORDEN = Threshold_Gamma('LORDEN', T, d, Pre_beta, Gamma, w);

%% Compare the procedures through the simulated EDDs
% Note that EDD_... is a result vector for 10000 Monte Carlo trials


% This is a library for the threshold already computed. This is used to
% reduce the time for computing it again.
% The following is for d = 1, w = 100:
b_CUSUM = 6.8339; 
b_WLGLR = 7.67;
b_WLACM = 7.8148;
b_WLSRRS = 9.0883;
b_LORDEN = 7.9314;

% b_WLSRRS = 6.9289;
% b_WLACM_L1 = 8.00;
% b_WLSRRS_L1 = 8.03;



%% Draw plots
% This part draws a plot: EDD versus p;
T = 200;
%p_mesh = [0.35;0.5;0.6;0.7;0.9;1];
beta_mesh = [0.1;0.5;2;5;10];
%p_mesh = [0.9];
l = length(beta_mesh);
EDD_CUSUM_mesh = zeros(l,1); EDDSTD_CUSUM_mesh = zeros(l,1);
%EDD_WLGLR_mesh = zeros(l,1); EDDSTD_WLGLR_mesh = zeros(l,1);
EDD_WLGLR_V_mesh = zeros(l,1); EDDSTD_WLGLR_V_mesh = zeros(l,1);
EDD_WLSRRS_mesh = zeros(l,1); EDDSTD_WLSRRS_mesh = zeros(l,1);
EDD_WLACM_mesh = zeros(l,1); EDDSTD_WLACM_mesh = zeros(l,1);
EDD_LORDEN_mesh = zeros(l,1); EDDSTD_LORDEN_mesh = zeros(l,1);
%EDD_WLSRRS_L1_mesh = zeros(l,1); EDDSTD_WLSRRS_L1_mesh = zeros(l,1);
%EDD_WLACM_L1_mesh = zeros(l,1); EDDSTD_WLACM_L1_mesh = zeros(l,1);


Time_CUSUM = 0;
Time_WLGLR = 0;
Time_WLGLR_V = 0;
Time_WLACM = 0;
Time_WLSRRS = 0;
Time_WLACM_L1 = 0;
Time_WLSRRS_L1 = 0;
Time_LORDEN = 0;
for i = 1 : l

    Post_beta = beta_mesh(i);
    %CUSUM
    tic;
    [~,EDD_CUSUM_mesh(i),EDDSTD_CUSUM_mesh(i)] = ...
        EDD_Gamma('CUSUM', T, d, Pre_beta, Post_beta, b_CUSUM, w);
    Time_CUSUM = Time_CUSUM + toc;
    % WLGLR_V
    tic;
    [~,EDD_WLGLR_V_mesh(i),EDDSTD_WLGLR_V_mesh(i)] = ... 
        EDD_Gamma('WLGLR_V', T, d, Pre_beta, Post_beta, b_WLGLR, w);
    Time_WLGLR_V = Time_WLGLR_V + toc;
    %WLSRRS
    tic;
    [~,EDD_WLSRRS_mesh(i), EDDSTD_WLSRRS_mesh(i)] = ... 
        EDD_Gamma('WLSRRS', T, d, Pre_beta, Post_beta, b_WLSRRS, w);
    Time_WLSRRS = Time_WLSRRS + toc;
    %WLACM
    tic;
    [~,EDD_WLACM_mesh(i), EDDSTD_WLACM_mesh(i)] = ...
        EDD_Gamma('WLACM', T, d, Pre_beta, Post_beta, b_WLACM, w);
    Time_WLACM = Time_WLACM + toc;
    %LORDEN
    tic;
    [~,EDD_LORDEN_mesh(i), EDDSTD_LORDEN_mesh(i)] = ...
        EDD_Gamma('LORDEN', T, d, Pre_beta, Post_beta, b_LORDEN, w);
    Time_LORDEN = Time_LORDEN + toc;
end


%%
figure; 
co = 1;
plot(beta_mesh(co:end),EDD_CUSUM_mesh(co:end),'--k*');
hold on; plot(beta_mesh(co:end),EDD_WLGLR_V_mesh(co:end),'--m+');
hold on; plot(beta_mesh(co:end),EDD_WLSRRS_mesh(co:end),'--go');
hold on; plot(beta_mesh(co:end),EDD_WLACM_mesh(co:end),'--rx');
hold on; plot(beta_mesh(co:end),EDD_LORDEN_mesh(co:end),'--bs');
%hold on; plot(beta_mesh(co:end),EDD_WLSRRS_L1_mesh(co:end),'-gd')
%hold on; plot(beta_mesh(co:end),EDD_WLACM_L1_mesh(co:end),'-rs')
legend('CUSUM','WLGLR, w=100', 'WLSRRS, w=100', 'WLACM, w=100','LORDEN, w=100');
xlabel('\beta');
ylabel('EDD');
xlim([beta_mesh(co)-0.01 beta_mesh(end)]);
box on;
boldify;
%print -dpdf EDD_mesh_normal_mean_changeP.pdf

%save LORDEN








