clear all
close all

%% Parameters for the random Erdos Renyi graph
Num_vertice = 20; 
d = round(Num_vertice*(Num_vertice-1)/2);

Pre_p = 0.2;

w = 100;

%% Calculate the threshold b in order to make ARL be Gamma
Gamma = 10000;

T = 500; % the length of pre-change sequence

%b_CUSUM = Threshold_ERgraph('CUSUM', T, Num_vertice, Pre_p, Gamma, w);
%b_WLGLR = Threshold_ERgraph('WLGLR', T, Num_vertice, Pre_p, Gamma, w);
%b_WLGLR_V = Threshold_ERgraph('WLGLR_V', T, Num_vertice, Pre_p, Gamma, w);
%b_WLACM = Threshold_ERgraph('WLACM', T, Num_vertice, Pre_p, Gamma, w);
%b_WLSRRS = Threshold_ERgraph('WLSRRS', T, Num_vertice, Pre_p, Gamma, w);


%%

b_CUSUM = -22.76;
b_WLGLR = 190;
b_WLACM = 0;
b_WLSRRS = 1;
%% Compare the procedures through the simulated EDDs

T = 500; % the length of the post-change series

Edge_mesh = [78;100;120;150;170;190];
l = length(Edge_mesh);
EDD_CUSUM_mesh = zeros(l,1); EDDSTD_CUSUM_mesh = zeros(l,1);
EDD_WLGLR_mesh = zeros(l,1); EDDSTD_WLGLR_mesh = zeros(l,1);
EDD_WLGLR_V_mesh = zeros(l,1); EDDSTD_WLGLR_V_mesh = zeros(l,1);
EDD_WLSRRS_mesh = zeros(l,1); EDDSTD_WLSRRS_mesh = zeros(l,1);
EDD_WLACM_mesh = zeros(l,1); EDDSTD_WLACM_mesh = zeros(l,1);


%%

Time_CUSUM = 0;
Time_WLGLR = 0;
Time_WLGLR_V = 0;
Time_WLACM = 0;
Time_WLSRRS = 0;
Time_WLACM_L1 = 0;
Time_WLSRRS_L1 = 0;

for i = 1 : l
    Num_edge = Edge_mesh(i);
    Post_p = 0.2*ones(d,1);
    for kk = 1 : Num_edge
        Post_p(kk) = 0.8;
    end
    Post_p = repmat(Post_p,1,T);
    
    %CUSUM
    tic;
    [~,EDD_CUSUM_mesh(i),EDDSTD_CUSUM_mesh(i)] = ...
        EDD_ERgraph('CUSUM', T, Num_vertice, Pre_p, Post_p, b_CUSUM, w);
    Time_CUSUM = Time_CUSUM + toc;
    %WLGLR
    tic;
    [~,EDD_WLGLR_mesh(i),EDDSTD_WLGLR_mesh(i)] = ... 
        EDD_ERgraph('WLGLR', T, Num_vertice, Pre_p, Post_p, b_WLGLR, w);
    Time_WLGLR = Time_WLGLR + toc;
    %WLGLR_V
    tic;
    [~,EDD_WLGLR_V_mesh(i),EDDSTD_WLGLR_V_mesh(i)] = ... 
        EDD_ERgraph('WLGLR_V', T, Num_vertice, Pre_p, Post_p, b_WLGLR, w);
    Time_WLGLR_V = Time_WLGLR_V + toc;
    %WLSRRS
    tic;
    [~,EDD_WLSRRS_mesh(i), EDDSTD_WLSRRS_mesh(i)] = ... 
        EDD_ERgraph('WLSRRS', T, Num_vertice, Pre_p, Post_p, b_WLSRRS, w);
    Time_WLSRRS = Time_WLSRRS + toc;
    %[~,EDD_WLSRRS_L1_mesh(i), EDDSTD_WLSRRS_L1_mesh(i)] = ... 
    %    EDD_normal_mean('WLSRRS', T, d, Pre_mean, Post_mean, b_WLSRRS, w);
    tic;
    [~,EDD_WLACM_mesh(i), EDDSTD_WLACM_mesh(i)] = ...
        EDD_ERgraph('WLACM', T, Num_vertice, Pre_p, Post_p, b_WLACM, w);
    Time_WLACM = Time_WLACM + toc;
    %[~,EDD_WLACM_L1_mesh(i), EDDSTD_WLACM_L1_mesh(i)] = ...
    %    EDD_normal_mean('WLACM_L1', T, d, Pre_mean, Post_mean, b_WLACM, w);
end

%%
figure; 
co = 1;
plot(Edge_mesh(co:end),EDD_CUSUM_mesh(co:end),'--k*');
hold on; plot(Edge_mesh(co:end),EDD_WLGLR_mesh(co:end),'--m+')
hold on; plot(Edge_mesh(co:end),EDD_WLSRRS_mesh(co:end),'--go')
hold on; plot(Edge_mesh(co:end),EDD_WLACM_mesh(co:end),'--rx')
%hold on; plot(mu_mesh(co:end),EDD_WLSRRS_L1_mesh(co:end),'-gd')
%hold on; plot(mu_mesh(co:end),EDD_WLACM_L1_mesh(co:end),'-rs')

legend('CUSUM','GLR', 'SRRS', 'ACM')
xlabel('n')
ylabel('EDD')
xlim([Edge_mesh(co) Edge_mesh(end)])
box on;
myboldify;
%print -dpdf EDD_mesh_ERgraph.pdf
